/*
 * Decompiled with CFR 0.152.
 */
package pages.client.gui;

import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mystlibrary.localization.Localization;
import mystlibrary.symbol.behavior.BlockStateBehavior;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import pages.client.gui.GuiScreenBase;
import pages.client.gui.element.GuiElementBlockPropertiesEditor;
import pages.client.gui.element.GuiElementBlockWriterListener;
import pages.client.gui.element.GuiElementGrammarRuleEditor;
import pages.client.gui.element.GuiElementListItemGrammarRule;
import pages.client.gui.element.GuiElementPoemEditor;
import pages.client.gui.element.generic.GuiElement;
import pages.client.gui.element.generic.GuiElementButton;
import pages.client.gui.element.generic.GuiElementString;
import pages.client.gui.element.generic.GuiElementTab;
import pages.client.gui.element.generic.GuiElementTextFieldLabeled;
import pages.client.gui.element.generic.GuiElementWindow;
import pages.client.gui.element.generic.keyvalidator.KeyValidators;

@SideOnly(value=Side.CLIENT)
public class GuiScreenBlockWriter
extends GuiScreenBase {
    public IBlockState blockState;
    public int guiWidth;
    public int guiHeight;
    public int guiLeft;
    public int guiTop;
    protected Collection<BlockCategory> blockCategories = new ArrayList<BlockCategory>(BlockCategory.getCategories());
    protected BlockStateBehavior behavior;
    protected JsonObject blockJson;
    public GuiElementTab tabGeneral;
    public GuiElementTab tabGrammar;
    public GuiElementTab tabBlock;
    public GuiElementTextFieldLabeled symbolIdField;
    public GuiElementPoemEditor poemEditor;
    public GuiElementTextFieldLabeled cardRankField;
    public GuiElementGrammarRuleEditor grammarRuleEditor;
    public GuiElementBlockPropertiesEditor propertiesEditor;
    public GuiElementTextFieldLabeled baseInstabilityField;
    public GuiElementTextFieldLabeled exposedInstabilityField;

    public GuiScreenBlockWriter(IBlockState state) {
        this.blockState = state;
        this.guiWidth = 256;
        this.guiHeight = 130;
        this.blockCategories.remove(BlockCategory.ANY);
        this.behavior = new BlockStateBehavior(state, new ArrayList(), 0.0f, 0.0f);
        this.blockJson = this.behavior.toJson();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.guiLeft = (this.field_146294_l - this.guiWidth) / 2;
        this.guiTop = (this.field_146295_m - this.guiHeight + 18) / 2;
        this.addElement(new GuiElementWindow(ElementIds.WINDOW.ordinal(), this.guiLeft, this.guiTop, this.guiWidth, this.guiHeight, null, null, 0.0f));
        GuiElementBlockWriterListener screenListener = this.addElement(new GuiElementBlockWriterListener(ElementIds.SCREEN_LISTENER.ordinal(), 0, 0, 0, 0, null, null, this, Float.valueOf(this.field_73735_i)));
        String blockString = new TextComponentTranslation("gui.pages.block_writer.tab.block", new Object[0]).func_150254_d();
        this.tabBlock = new GuiElementTab(ElementIds.TAB_BLOCK.ordinal(), 0, 0, null, Arrays.asList(new GuiElement[]{screenListener}), false, true, new GuiElementString(0, 0, 0, null, null, this.field_146297_k, blockString, Color.BLACK.getRGB(), 0.0f), 0.0f);
        this.tabBlock.x = this.guiLeft + this.guiWidth - this.tabBlock.width;
        this.tabBlock.y = this.guiTop - this.tabBlock.height;
        this.tabBlock = new GuiElementTab(this.tabBlock.id, this.tabBlock.x, this.tabBlock.y, this.tabBlock.validator, this.tabBlock.listeners, this.tabBlock.onLeftSide, this.tabBlock.onRightSide, new GuiElementString(0, 0, 0, null, null, this.field_146297_k, blockString, Color.BLACK.getRGB(), 0.0f), 0.0f);
        this.addElement(this.tabBlock);
        String grammarString = new TextComponentTranslation("gui.pages.block_writer.tab.grammar", new Object[0]).func_150254_d();
        this.tabGrammar = new GuiElementTab(ElementIds.TAB_GRAMMAR.ordinal(), 0, 0, null, Arrays.asList(new GuiElement[]{screenListener}), false, false, new GuiElementString(0, 0, 0, null, null, this.field_146297_k, grammarString, Color.BLACK.getRGB(), 0.0f), 0.0f);
        this.tabGrammar.x = this.guiLeft + this.guiWidth - this.tabGrammar.width - this.tabBlock.width + 1;
        this.tabGrammar.y = this.guiTop - this.tabGrammar.height;
        this.tabGrammar = new GuiElementTab(this.tabGrammar.id, this.tabGrammar.x, this.tabGrammar.y, this.tabGrammar.validator, this.tabGrammar.listeners, this.tabGrammar.onLeftSide, this.tabGrammar.onRightSide, new GuiElementString(0, 0, 0, null, null, this.field_146297_k, grammarString, Color.BLACK.getRGB(), 0.0f), 0.0f);
        this.addElement(this.tabGrammar);
        String generalString = new TextComponentTranslation("gui.pages.block_writer.tab.general", new Object[0]).func_150254_d();
        this.tabGeneral = new GuiElementTab(ElementIds.TAB_GENERAL.ordinal(), 0, 0, null, Arrays.asList(new GuiElement[]{screenListener}), false, false, new GuiElementString(0, 0, 0, null, null, this.field_146297_k, generalString, Color.BLACK.getRGB(), 0.0f), 0.0f);
        this.tabGeneral.x = this.guiLeft + this.guiWidth - this.tabGeneral.width - this.tabGrammar.width - this.tabBlock.width + 2;
        this.tabGeneral.y = this.guiTop - this.tabGeneral.height;
        this.tabGeneral = new GuiElementTab(this.tabGeneral.id, this.tabGeneral.x, this.tabGeneral.y, this.tabGeneral.validator, this.tabGeneral.listeners, this.tabGeneral.onLeftSide, this.tabGeneral.onRightSide, new GuiElementString(0, 0, 0, null, null, this.field_146297_k, generalString, Color.BLACK.getRGB(), 0.0f), 0.0f);
        this.addElement(this.tabGeneral);
        this.symbolIdField = this.tabGeneral.addElement(new GuiElementTextFieldLabeled(ElementIds.LABELED_FIELD_SYMBOL_ID.ordinal(), this.guiLeft + 7, this.guiTop + 7, this.guiWidth - 14, null, null, this.field_146297_k, new TextComponentTranslation("gui.pages.block_writer.element.symbol_id", new Object[0]).func_150254_d(), Color.BLACK.getRGB(), "pages:block_" + this.blockState.func_177230_c().getRegistryName().func_110623_a().toString(), Color.WHITE.getRGB(), 0.0f));
        this.poemEditor = this.tabGeneral.addElement(new GuiElementPoemEditor(ElementIds.POEM_EDITOR.ordinal(), this.guiLeft + 7, this.symbolIdField.y + this.symbolIdField.height + 8, this.guiWidth - 14, 54, null, null, this.field_146297_k, "Transform", "Constraint", "Block", Localization.getLocalizedBlockStateName((IBlockState)this.blockState).replace("Block", "").trim(), 0.0f));
        String cardRankString = new TextComponentTranslation("gui.pages.block_writer.element.card_rank", new Object[0]).func_150254_d();
        this.cardRankField = this.tabGeneral.addElement(new GuiElementTextFieldLabeled(ElementIds.LABELED_FIELD_CARD_RANK.ordinal(), this.guiLeft + 7, this.poemEditor.y + this.poemEditor.height + 8, this.field_146289_q.func_78256_a(cardRankString) + 4 + 24, KeyValidators::isInteger, null, this.field_146297_k, cardRankString, Color.BLACK.getRGB(), "2", Color.WHITE.getRGB(), 0.0f));
        String tooltipHelp = new TextComponentTranslation("gui.pages.block_writer.tooltips", new Object[0]).func_150254_d();
        this.addElement(new GuiElementString(500, this.guiLeft + this.guiWidth - 7 - this.field_146289_q.func_78256_a(tooltipHelp), this.cardRankField.y + this.cardRankField.height + 14, null, null, this.field_146297_k, tooltipHelp, new Color(85, 85, 85).getRGB(), 0.0f));
        this.addElement(new GuiElementButton(ElementIds.BUTTON_SAVE.ordinal(), this.guiLeft + 7, this.cardRankField.y + this.cardRankField.height + 8, 64, 14, "Save", null, Arrays.asList(new GuiElement[]{screenListener}), 0.0f));
        int id = 100;
        ArrayList<GuiElementListItemGrammarRule> categories = new ArrayList<GuiElementListItemGrammarRule>();
        for (BlockCategory category : this.blockCategories) {
            categories.add(new GuiElementListItemGrammarRule(id++, 0, 0, this.guiWidth - 14 - 14 - 4, null, null, this.field_146297_k, category.getName().toString(), 0.0f));
        }
        this.grammarRuleEditor = this.tabGrammar.addElement(new GuiElementGrammarRuleEditor(ElementIds.GRAMMAR_EDITOR.ordinal(), this.guiLeft + 7, this.guiTop + 8, this.guiWidth - 14, 74, null, null, this.field_146297_k, categories, 0.0f));
        String baseString = new TextComponentTranslation("gui.pages.block_writer.element.instability_base", new Object[0]).func_150254_d();
        String exposedString = new TextComponentTranslation("gui.pages.block_writer.element.instability_exposed", new Object[0]).func_150254_d();
        int fieldWidth = (this.guiWidth - 14 - 8 - 4 - this.field_146289_q.func_78256_a(baseString + exposedString)) / 2;
        this.baseInstabilityField = this.tabBlock.addElement(new GuiElementTextFieldLabeled(ElementIds.LABELED_FIELD_INSTABILITY_BASE.ordinal(), this.guiLeft + 7, this.guiTop + 7, this.field_146289_q.func_78256_a(baseString) + 2 + fieldWidth, KeyValidators::isFloat, null, this.field_146297_k, baseString, Color.BLACK.getRGB(), "", Color.WHITE.getRGB(), 0.0f));
        this.exposedInstabilityField = this.tabBlock.addElement(new GuiElementTextFieldLabeled(ElementIds.LABELED_FIELD_INSTABILITY_EXPOSED.ordinal(), this.baseInstabilityField.x + this.baseInstabilityField.width + 8, this.baseInstabilityField.y, this.field_146289_q.func_78256_a(exposedString) + 2 + fieldWidth, KeyValidators::isFloat, null, this.field_146297_k, exposedString, Color.BLACK.getRGB(), "", Color.WHITE.getRGB(), 0.0f));
        HashMap<String, List<String>> propertiesMap = new HashMap<String, List<String>>();
        Collection propertiesCollection = this.blockState.func_177227_a();
        for (IProperty property : propertiesCollection) {
            Collection possibleValues = property.func_177700_c();
            ArrayList<String> acceptableValues = new ArrayList<String>();
            for (Object singleValue : possibleValues) {
                if (singleValue instanceof IStringSerializable) {
                    String valueName = ((IStringSerializable)singleValue).func_176610_l().trim().toLowerCase();
                    acceptableValues.add(valueName);
                } else {
                    acceptableValues.add(singleValue.toString().trim().toLowerCase());
                }
                propertiesMap.put(property.func_177701_a(), acceptableValues);
            }
        }
        this.propertiesEditor = this.tabBlock.addElement(new GuiElementBlockPropertiesEditor(ElementIds.PROPERTIES_EDITOR.ordinal(), this.guiLeft + 7, this.exposedInstabilityField.y + this.exposedInstabilityField.height + 8, this.guiWidth - 14, 64, null, null, this.field_146297_k, propertiesMap, 0.0f));
        this.tabGeneral.notifyListeners();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (GuiScreenBlockWriter.func_146272_n()) {
            for (GuiElement element : Iterables.concat(this.tabGeneral.elementList.values(), this.tabGrammar.elementList.values(), this.tabBlock.elementList.values())) {
                String label = "";
                if (element.id == ElementIds.LABELED_FIELD_SYMBOL_ID.ordinal()) {
                    label = "symbol_id";
                } else if (element.id == ElementIds.POEM_EDITOR.ordinal()) {
                    label = "poem";
                } else if (element.id == ElementIds.LABELED_FIELD_CARD_RANK.ordinal()) {
                    label = "card_rank";
                } else if (element.id == ElementIds.GRAMMAR_EDITOR.ordinal()) {
                    label = "grammar_rules";
                } else if (element.id == ElementIds.LABELED_FIELD_INSTABILITY_BASE.ordinal()) {
                    label = "instability_base";
                } else if (element.id == ElementIds.LABELED_FIELD_INSTABILITY_EXPOSED.ordinal()) {
                    label = "instability_exposed";
                } else if (element.id == ElementIds.PROPERTIES_EDITOR.ordinal()) {
                    label = "properties";
                }
                if (label.trim().isEmpty()) continue;
                this.drawTranslatedTooltip(element, label, mouseX, mouseY);
            }
        }
    }

    public void drawTranslatedTooltip(GuiElement element, String path, int mouseX, int mouseY) {
        if (element.isMouseOver(mouseX, mouseY)) {
            this.func_146279_a(new TextComponentTranslation("tooltip.pages.block_writer." + path, new Object[0]).func_150260_c(), mouseX, mouseY);
        }
    }

    public static enum ElementIds {
        WINDOW,
        SCREEN_LISTENER,
        TAB_BLOCK,
        TAB_GRAMMAR,
        TAB_GENERAL,
        LABELED_FIELD_SYMBOL_ID,
        POEM_EDITOR,
        LABELED_FIELD_CARD_RANK,
        GRAMMAR_EDITOR,
        LABELED_FIELD_INSTABILITY_BASE,
        LABELED_FIELD_INSTABILITY_EXPOSED,
        PROPERTIES_EDITOR,
        BUTTON_SAVE;

    }
}

