/*
 * Decompiled with CFR 0.152.
 */
package pages.client.gui.element.generic;

import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pages.client.gui.element.generic.GuiElement;
import pages.client.gui.element.generic.keyvalidator.IKeyValidator;

public class GuiElementScrollbarVertical
extends GuiElement {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/gui/container/creative_inventory/tabs.png");
    protected int textureLightX = 232;
    protected int textureDarkX = 244;
    protected int textureY = 0;
    protected int puckWidth = 12;
    protected int puckHeight = 15;
    protected int puckX;
    protected int puckY;
    protected int practicalHeight;
    protected int localY;
    protected List<GuiElement> validScrollElements;
    protected boolean mouseDown;

    public GuiElementScrollbarVertical(int id, int x, int y, int height, IKeyValidator validator, List<GuiElement> listeners, List<GuiElement> validScrollElements, float zLevel) {
        super(id, x, y, 14, height, validator, listeners, zLevel);
        this.puckX = x + 1;
        this.puckY = y + 1;
        this.practicalHeight = height - 2 - this.puckHeight;
        this.mouseDown = false;
        this.validScrollElements = validScrollElements;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void drawElement(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            this.func_73730_a(this.x, this.x + this.width - 2, this.y, COLOR_DARKER_GRAY);
            this.func_73728_b(this.x, this.y, this.y + this.height - 1, COLOR_DARKER_GRAY);
            GuiElementScrollbarVertical.drawRect(this.x + 1, this.y + 1, this.x + this.width - 1, this.y + this.height - 1, COLOR_GRAY, this.field_73735_i);
            GuiElementScrollbarVertical.drawRect(this.x, this.y + this.height - 1, this.x + 1, this.y + this.height, COLOR_GRAY, this.field_73735_i);
            GuiElementScrollbarVertical.drawRect(this.x + this.width - 1, this.y, this.x + this.width, this.y + 1, COLOR_GRAY, this.field_73735_i);
            this.func_73728_b(this.x + this.width - 1, this.y, this.y + this.height - 1, COLOR_WHITE);
            this.func_73730_a(this.x + 1, this.x + this.width - 1, this.y + this.height - 1, COLOR_WHITE);
            mc.func_110434_K().func_110577_a(TEXTURE);
            this.func_73729_b(this.puckX, this.puckY, this.textureLightX, this.textureY, this.puckWidth, this.puckHeight);
        }
    }

    @Override
    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY, int mouseButton) {
        if (this.isVisible() && mouseButton == 0 && this.isOverPuck(mouseX, mouseY)) {
            this.localY = mouseY - this.puckY;
            this.mouseDown = true;
            return true;
        }
        return false;
    }

    @Override
    public void onMouseWheel(int mouseX, int mouseY, int value) {
        if (this.isVisible() && this.isEnabled()) {
            GuiElement element;
            boolean valid = false;
            Iterator<GuiElement> iterator = this.validScrollElements.iterator();
            while (iterator.hasNext() && !(valid = (element = iterator.next()).isMouseOver(mouseX, mouseY))) {
            }
            if (valid) {
                this.setPuckPosition(MathHelper.func_76131_a((float)(this.getPuckPosition() - (float)value * 0.1f), (float)0.0f, (float)1.0f));
                this.notifyListeners();
            }
        }
        super.onMouseWheel(mouseX, mouseY, value);
    }

    @Override
    public void mouseDragged(Minecraft mc, int mouseX, int mouseY, int mouseButton) {
        if (this.isVisible()) {
            if (mouseButton == 0 && this.mouseDown) {
                this.puckY = MathHelper.func_76125_a((int)(mouseY - this.localY), (int)(this.y + 1), (int)(this.y + this.height - this.puckHeight - 1));
                this.notifyListeners();
            }
            super.mouseDragged(mc, mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.mouseDown = false;
        super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    @Override
    public void restore(GuiElement backup) {
        if (backup instanceof GuiElementScrollbarVertical) {
            this.setPuckPosition(((GuiElementScrollbarVertical)backup).getPuckPosition());
            this.notifyListeners();
        }
    }

    public boolean isOverPuck(int x, int y) {
        return x >= this.puckX && x < this.puckX + this.puckWidth && y >= this.puckY && y < this.puckY + this.puckHeight;
    }

    public void setPuckPosition(float pos) {
        pos = MathHelper.func_76131_a((float)pos, (float)0.0f, (float)1.0f);
        this.puckY = (int)(pos * (float)this.practicalHeight + (float)this.y + 1.0f);
    }

    public float getPuckPosition() {
        return ((float)this.puckY - ((float)this.y + 1.0f)) / (float)this.practicalHeight;
    }
}

