/*
 * Decompiled with CFR 0.152.
 */
package pages.network.packets;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.ArrayList;
import mystlibrary.exception.ModMissingException;
import mystlibrary.exception.SymbolBuildException;
import mystlibrary.symbol.SymbolMetadata;
import mystlibrary.symbol.behavior.BlockStateBehavior;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pages.Pages;
import pages.client.gui.GuiScreenBlockWriter;

public class PacketBlockStateSymbol
implements IMessage {
    IBlockState blockState;

    public PacketBlockStateSymbol(IBlockState state) {
        this.blockState = state;
    }

    public PacketBlockStateSymbol() {
        this.blockState = Blocks.field_150350_a.func_176223_P();
    }

    public void fromBytes(ByteBuf buf) {
        String stateString = buf.readCharSequence(buf.readableBytes(), Charset.defaultCharset()).toString();
        JsonObject stateObject = new JsonParser().parse(stateString).getAsJsonObject();
        SymbolMetadata metadata = new SymbolMetadata();
        metadata.cardRank = 0;
        metadata.grammarRules = new ArrayList();
        metadata.instabilityPerInstance = 0;
        metadata.localizationParameters = new ArrayList();
        metadata.maxCount = 0;
        metadata.name = Pages.resource("transmitted_block");
        metadata.poem = new ArrayList();
        metadata.unlocalName = "";
        try {
            this.blockState = ((BlockStateBehavior)BlockStateBehavior.fromJson((JsonObject)stateObject, (SymbolMetadata)metadata)).blockDescriptor.blockstate;
        }
        catch (ModMissingException.BlockSymbol | SymbolBuildException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        JsonObject stateObject = new BlockStateBehavior(this.blockState, new ArrayList(), 0.0f, 0.0f).toJson();
        String stateString = stateObject.toString();
        buf.writeCharSequence((CharSequence)stateString, Charset.defaultCharset());
    }

    public static class Handler
    implements IMessageHandler<PacketBlockStateSymbol, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketBlockStateSymbol msg, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBlockWriter(msg.blockState)));
            return null;
        }
    }
}

