/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.boot;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GradleHacks {
    private static final Logger LOGGER = Logger.getLogger("GradleForgeHacks");
    private static final String NO_CORE_SEARCH = "--noCoreSearch";
    private static final String COREMOD_VAR = "fml.coreMods.load";
    private static final String COREMOD_MF = "FMLCorePlugin";

    public static void searchCoremods(Collection<String> args) {
        if (args.contains(NO_CORE_SEARCH)) {
            LOGGER.info("GradleForgeHacks coremod searching disabled!");
            args.remove(NO_CORE_SEARCH);
            return;
        }
        Map<String, File> coreMap = GradleHacks.searchCoremods();
        ArrayList<String> coremodsList = new ArrayList<String>();
        String coremodVar = System.getProperty(COREMOD_VAR);
        if (!Strings.isNullOrEmpty((String)coremodVar)) {
            String[] split = coremodVar.split(",");
            Collections.addAll(coremodsList, split);
        }
        coremodsList.addAll(coreMap.keySet());
        System.setProperty(COREMOD_VAR, Joiner.on((String)",").join(coremodsList));
    }

    private static Map<String, File> searchCoremods() {
        HashMap<String, File> coreMap = new HashMap<String, File>();
        for (URL url : GradleHacks.getClassPathURLs()) {
            try {
                GradleHacks.searchCoremodAtUrl(url, coreMap);
            }
            catch (IOException | IllegalAccessException | InvocationTargetException | URISyntaxException e) {
                LOGGER.log(Level.WARNING, "GradleForgeHacks failed to search for coremod at url " + String.valueOf(url), e);
            }
        }
        return coreMap;
    }

    private static void searchCoremodAtUrl(URL url, Map<String, File> map) throws IOException, InvocationTargetException, IllegalAccessException, URISyntaxException {
        String clazz;
        if (!url.getProtocol().startsWith("file")) {
            return;
        }
        File coreMod = new File(url.toURI().getPath());
        Manifest manifest = null;
        if (!coreMod.exists()) {
            return;
        }
        if (coreMod.isDirectory()) {
            File manifestMF = new File(coreMod, "META-INF/MANIFEST.MF");
            if (manifestMF.exists()) {
                FileInputStream stream = new FileInputStream(manifestMF);
                manifest = new Manifest(stream);
                stream.close();
            }
        } else if (coreMod.getName().endsWith(".jar")) {
            try (JarFile jar = new JarFile(coreMod);){
                manifest = jar.getManifest();
            }
        }
        if (manifest != null && !Strings.isNullOrEmpty((String)(clazz = manifest.getMainAttributes().getValue(COREMOD_MF)))) {
            LOGGER.info("Found and added coremod: " + clazz);
            map.put(clazz, coreMod);
        }
    }

    private static List<URL> getClassPathURLs() {
        String[] classpaths = System.getProperty("java.class.path").split(File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String classpath : classpaths) {
                urls.add(new File(classpath).toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return urls;
    }
}

