/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.client.ime;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.function.Consumer;

public class WindowsIMEHandler
implements Consumer<Boolean> {
    User32 user32 = User32.INSTANCE;

    private static native WinNT.HANDLE ImmGetContext(WinDef.HWND var0);

    private static native WinNT.HANDLE ImmAssociateContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native boolean ImmReleaseContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native WinNT.HANDLE ImmCreateContext();

    private static native boolean ImmDestroyContext(WinNT.HANDLE var0);

    @Override
    public void accept(Boolean active) {
        WinNT.HANDLE himc;
        WinDef.HWND hwnd = this.user32.GetForegroundWindow();
        if (active.booleanValue()) {
            himc = WindowsIMEHandler.ImmGetContext(hwnd);
            if (himc == null) {
                himc = WindowsIMEHandler.ImmCreateContext();
                WindowsIMEHandler.ImmAssociateContext(hwnd, himc);
            }
        } else {
            himc = WindowsIMEHandler.ImmAssociateContext(hwnd, null);
            if (himc != null) {
                WindowsIMEHandler.ImmDestroyContext(himc);
            }
        }
        WindowsIMEHandler.ImmReleaseContext(hwnd, himc);
    }

    static {
        Native.register((String)"imm32");
    }
}

