/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.IOUtils;

public enum OBJLoader implements ICustomModelLoader
{
    INSTANCE;

    private cep manager;
    private final Set<String> enabledDomains = new HashSet<String>();

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
        FMLLog.log.info("OBJLoader: Domain {} has been added.", (Object)domain.toLowerCase());
    }

    @Override
    public void a(cep resourceManager) {
        this.manager = resourceManager;
    }

    @Override
    public boolean accepts(nf modelLocation) {
        return this.enabledDomains.contains(modelLocation.b()) && modelLocation.a().endsWith(".obj");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModel loadModel(nf modelLocation) throws Exception {
        OBJModel oBJModel;
        nf file = new nf(modelLocation.b(), modelLocation.a());
        ceo resource = null;
        try {
            OBJModel model;
            try {
                resource = this.manager.a(file);
            }
            catch (FileNotFoundException e) {
                if (modelLocation.a().startsWith("models/block/")) {
                    resource = this.manager.a(new nf(file.b(), "models/item/" + file.a().substring("models/block/".length())));
                }
                if (modelLocation.a().startsWith("models/item/")) {
                    resource = this.manager.a(new nf(file.b(), "models/block/" + file.a().substring("models/item/".length())));
                }
                throw e;
            }
            OBJModel.Parser parser = new OBJModel.Parser(resource, this.manager);
            try {
                model = parser.parse();
            }
            catch (Exception e) {
                throw new ModelLoaderRegistry.LoaderException("Error loading model previously: " + String.valueOf(file), e);
            }
            oBJModel = model;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(resource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)resource);
        return oBJModel;
    }
}

