/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.client.CloudRenderer;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ReloadRequirements;
import net.minecraftforge.client.resource.SelectiveReloadStateHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.client.DefaultGuiFactory;
import net.minecraftforge.fml.client.ExtendedServerListData;
import net.minecraftforge.fml.client.GuiAccessDenied;
import net.minecraftforge.fml.client.GuiConfirmation;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.GuiNotification;
import net.minecraftforge.fml.client.GuiOldSaveLoadConfirm;
import net.minecraftforge.fml.client.IDisplayableError;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.DuplicateModsFoundException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLContainerHolder;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IFMLSidedHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.MissingModsException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.MultipleModsErrored;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.StartupQuery;
import net.minecraftforge.fml.common.WrongMinecraftVersionException;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.toposort.ModSortingException;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private bib client;
    private DummyModContainer optifineContainer;
    @Deprecated
    private MissingModsException modsMissing;
    private boolean loading = true;
    @Nullable
    private IDisplayableError errorToDisplay;
    private boolean serverShouldBeKilledQuietly;
    private List<cer> resourcePackList;
    private cfg metaSerializer;
    private Map<String, cer> resourcePackMap;
    private BiMap<ModContainer, IModGuiFactory> guiFactories;
    private Map<mt, JsonObject> extraServerListData;
    private Map<bse, ExtendedServerListData> serverDataTag;
    private WeakReference<brz> currentPlayClient;
    private CloudRenderer cloudRenderer;
    private static final nf iconSheet = new nf("fml:textures/gui/icons.png");
    private static final CountDownLatch startupConnectionData = new CountDownLatch(1);
    private SetMultimap<String, nf> missingTextures = HashMultimap.create();
    private Set<String> badTextureDomains = Sets.newHashSet();
    private Table<String, String, Set<nf>> brokenTextures = HashBasedTable.create();
    private static final String ALLOWED_CHARS = "\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000";
    private static final CharMatcher DISALLOWED_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000").negate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginMinecraftLoading(bib minecraft, List<cer> resourcePackList, cen resourceManager, cfg metaSerializer) {
        this.detectOptifine();
        SplashProgress.start();
        this.client = minecraft;
        this.resourcePackList = resourcePackList;
        this.metaSerializer = metaSerializer;
        this.resourcePackMap = Maps.newHashMap();
        if (minecraft.u()) {
            FMLLog.log.fatal("DEMO MODE DETECTED, FML will not work. Finishing now.");
            this.haltGame("FML will not run in demo mode", new RuntimeException());
            return;
        }
        List<String> injectedModContainers = FMLCommonHandler.instance().beginLoading(this);
        try {
            Loader.instance().loadMods(injectedModContainers);
        }
        catch (CustomModLoadingErrorDisplayException | DuplicateModsFoundException | MissingModsException | MultipleModsErrored | WrongMinecraftVersionException | ModSortingException e) {
            FMLLog.log.error("An exception was thrown, the game will display an error screen and halt.", (Throwable)e);
            this.errorToDisplay = (IDisplayableError)((Object)e);
            MinecraftForge.EVENT_BUS.shutdown();
        }
        catch (LoaderException le) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        finally {
            this.client.f();
        }
        try {
            Loader.instance().preinitializeMods();
        }
        catch (LoaderException le) {
            if (le.getCause() instanceof CustomModLoadingErrorDisplayException) {
                CustomModLoadingErrorDisplayException custom = (CustomModLoadingErrorDisplayException)le.getCause();
                FMLLog.log.error("A custom exception was thrown by a mod, the game will display an error screen and halt.", (Throwable)custom);
                this.errorToDisplay = custom;
                MinecraftForge.EVENT_BUS.shutdown();
            }
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        Keyboard.populateKeyLookupTables();
        Map sharedModList = (Map)Launch.blackboard.get("modList");
        if (sharedModList == null) {
            sharedModList = Maps.newHashMap();
            Launch.blackboard.put("modList", sharedModList);
        }
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            Map<String, String> sharedModDescriptor = mc.getSharedModDescriptor();
            if (sharedModDescriptor == null) continue;
            String sharedModId = "fml:" + mc.getModId();
            sharedModList.put(sharedModId, sharedModDescriptor);
        }
    }

    private void detectOptifine() {
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            String optifineVersion = (String)optifineConfig.getField("VERSION").get(null);
            ImmutableMap dummyOptifineMeta = ImmutableMap.builder().put((Object)"name", (Object)"Optifine").put((Object)"version", (Object)optifineVersion).build();
            try (InputStream optifineModInfoInputStream = this.getClass().getResourceAsStream("optifinemod.info");){
                ModMetadata optifineMetadata = MetadataCollection.from(optifineModInfoInputStream, "optifine").getMetadataForId("optifine", (Map<String, Object>)dummyOptifineMeta);
                this.optifineContainer = new DummyModContainer(optifineMetadata);
                FMLLog.log.info("Forge Mod Loader has detected optifine {}, enabling compatibility features", (Object)this.optifineContainer.getVersion());
            }
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
    }

    @Override
    public void haltGame(String message, Throwable t) {
        SplashProgress.finish();
        this.client.c(new b(message, t));
        Throwables.throwIfUnchecked((Throwable)t);
        throw new RuntimeException(t);
    }

    public boolean hasError() {
        return this.errorToDisplay != null;
    }

    public void finishMinecraftLoading() {
        if (this.hasError()) {
            SplashProgress.finish();
            return;
        }
        try {
            Loader.instance().initializeMods();
        }
        catch (LoaderException le) {
            if (le.getCause() instanceof CustomModLoadingErrorDisplayException) {
                CustomModLoadingErrorDisplayException custom = (CustomModLoadingErrorDisplayException)le.getCause();
                FMLLog.log.error("A custom exception was thrown by a mod, the game will display an error screen and halt.", (Throwable)custom);
                this.errorToDisplay = custom;
                MinecraftForge.EVENT_BUS.shutdown();
            }
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le);
            return;
        }
        if (Boolean.parseBoolean(System.getProperty("fml.reloadResourcesOnStart", "false"))) {
            this.client.f();
        }
        RenderingRegistry.loadEntityRenderers(bib.z().ac().k);
        this.guiFactories = HashBiMap.create();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            String className = mc.getGuiClassName();
            if (Strings.isNullOrEmpty((String)className)) {
                if (!ConfigManager.hasConfigForMod(mc.getModId())) continue;
                this.guiFactories.put((Object)mc, (Object)DefaultGuiFactory.forMod(mc));
                continue;
            }
            try {
                Class<?> clazz = Class.forName(className, true, Loader.instance().getModClassLoader());
                Class<IModGuiFactory> guiClassFactory = clazz.asSubclass(IModGuiFactory.class);
                IModGuiFactory guiFactory = guiClassFactory.newInstance();
                guiFactory.initialize(this.client);
                this.guiFactories.put((Object)mc, (Object)guiFactory);
            }
            catch (Exception e) {
                FMLLog.log.error("A critical error occurred instantiating the gui factory for mod {}", (Object)mc.getModId(), (Object)e);
            }
        }
        this.loading = false;
        this.client.t.a();
        if (!this.hasError()) {
            Loader.instance().loadingComplete();
        }
        SplashProgress.finish();
    }

    public void extendModList() {
        Map modList = (Map)Launch.blackboard.get("modList");
        if (modList != null) {
            for (Map.Entry modEntry : modList.entrySet()) {
                String sharedModId = (String)modEntry.getKey();
                String system = sharedModId.split(":")[0];
                if (!"fml".equals(system)) continue;
            }
        }
    }

    public void onInitializationComplete() {
        bus.z();
        bus.y();
        if (this.errorToDisplay != null) {
            blk errorScreen = this.errorToDisplay.createGui();
            this.showGuiScreen(errorScreen);
        } else {
            this.logMissingTextureErrors();
        }
    }

    public bib getClient() {
        return this.client;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public void displayGuiScreen(aed player, blk gui) {
        if (this.client.h == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return ImmutableList.of();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean hasOptifine() {
        return this.optifineContainer != null;
    }

    @Override
    public void showGuiScreen(@Nullable Object clientGuiElement) {
        blk gui = (blk)clientGuiElement;
        this.client.a(gui);
    }

    @Override
    public void queryUser(StartupQuery query) throws InterruptedException {
        if (query.getResult() == null) {
            this.client.a((blk)new GuiNotification(query));
        } else {
            this.client.a((blk)new GuiConfirmation(query));
        }
        if (query.isSynchronous()) {
            while (this.client.m instanceof GuiNotification) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.client.n.c("");
                Thread.sleep(50L);
            }
            this.client.n.c("");
        }
    }

    public boolean handleLoadingScreen(bit scaledResolution) throws IOException {
        if (this.client.m instanceof GuiNotification) {
            int width = scaledResolution.a();
            int height = scaledResolution.b();
            int mouseX = Mouse.getX() * width / this.client.d;
            int mouseZ = height - Mouse.getY() * height / this.client.e - 1;
            this.client.m.a(mouseX, mouseZ, 0.0f);
            this.client.m.q();
            return true;
        }
        return false;
    }

    public bsb getWorldClient() {
        return this.client.f;
    }

    public bud getClientPlayerEntity() {
        return this.client.h;
    }

    @Override
    public void beginServerLoading(MinecraftServer server) {
        this.serverShouldBeKilledQuietly = false;
    }

    @Override
    public void finishServerLoading() {
    }

    @Override
    public File getSavesDirectory() {
        return ((bfc)this.client.g()).a;
    }

    @Override
    public MinecraftServer getServer() {
        return this.client.F();
    }

    @Deprecated
    public void displayMissingMods(Object modMissingPacket) {
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean isDisplayCloseRequested() {
        return Display.isCreated() && Display.isCloseRequested();
    }

    @Override
    public boolean shouldServerShouldBeKilledQuietly() {
        return this.serverShouldBeKilledQuietly;
    }

    public boolean isGUIOpen(Class<? extends blk> gui) {
        return this.client.m != null && this.client.m.getClass().equals(gui);
    }

    @Override
    public void addModAsResource(ModContainer container) {
        Class<?> resourcePackType = container.getCustomResourcePackClass();
        if (resourcePackType != null) {
            try {
                cer pack = (cer)resourcePackType.getConstructor(ModContainer.class).newInstance(container);
                cfr meta = (cfr)pack.a(this.metaSerializer, "pack");
                if (meta != null && meta.b() == 2) {
                    pack = new ces(pack);
                }
                this.resourcePackList.add(pack);
                this.resourcePackMap.put(container.getModId(), pack);
            }
            catch (NoSuchMethodException e) {
                FMLLog.log.error("The container {} (type {}) returned an invalid class for its resource pack.", (Object)container.getName(), (Object)container.getClass().getName());
            }
            catch (Exception e) {
                FormattedMessage message = new FormattedMessage("An unexpected exception occurred constructing the custom resource pack for {} ({})", (Object)container.getName(), (Object)container.getModId());
                throw new RuntimeException(message.getFormattedMessage(), e);
            }
        }
    }

    public cer getResourcePackFor(String modId) {
        return this.resourcePackMap.get(modId);
    }

    @Override
    public String getCurrentLanguage() {
        return this.client.Q().c().a();
    }

    @Override
    public void serverStopped() {
        GameData.revertToFrozen();
    }

    @Override
    public hb getClientPlayHandler() {
        return this.currentPlayClient == null ? null : (hb)this.currentPlayClient.get();
    }

    @Override
    public gw getClientToServerNetworkManager() {
        return this.client.v() != null ? this.client.v().a() : null;
    }

    public void handleClientWorldClosing(bsb world) {
        gw client = this.getClientToServerNetworkManager();
        if (client != null && !client.c()) {
            GameData.revertToFrozen();
        }
    }

    public void startIntegratedServer(String id, String name, amx settings) {
    }

    public File getSavesDir() {
        return new File(this.client.w, "saves");
    }

    public void tryLoadExistingWorld(bok selectWorldGUI, bfh comparator) {
        fy leveldat;
        File dir = new File(this.getSavesDir(), comparator.a());
        try {
            leveldat = gi.a((InputStream)new FileInputStream(new File(dir, "level.dat")));
        }
        catch (Exception e) {
            try {
                leveldat = gi.a((InputStream)new FileInputStream(new File(dir, "level.dat_old")));
            }
            catch (Exception e1) {
                FMLLog.log.warn("There appears to be a problem loading the save {}, both level files are unreadable.", (Object)comparator.a());
                return;
            }
        }
        fy fmlData = leveldat.p("FML");
        if (fmlData.e("ModItemData")) {
            this.showGuiScreen((Object)new GuiOldSaveLoadConfirm(comparator.a(), comparator.b(), (blk)selectWorldGUI));
        } else {
            try {
                this.client.a(comparator.a(), comparator.b(), null);
            }
            catch (StartupQuery.AbortedException abortedException) {
                // empty catch block
            }
        }
    }

    public void showInGameModOptions(blg guiIngameMenu) {
        this.showGuiScreen((Object)new GuiModList((blk)guiIngameMenu));
    }

    public IModGuiFactory getGuiFactoryFor(ModContainer selectedMod) {
        return (IModGuiFactory)this.guiFactories.get((Object)selectedMod);
    }

    public void setupServerList() {
        this.extraServerListData = Collections.synchronizedMap(Maps.newHashMap());
        this.serverDataTag = Collections.synchronizedMap(Maps.newHashMap());
    }

    public void captureAdditionalData(mt serverstatusresponse, JsonObject jsonobject) {
        if (jsonobject.has("modinfo")) {
            JsonObject fmlData = jsonobject.get("modinfo").getAsJsonObject();
            this.extraServerListData.put(serverstatusresponse, fmlData);
        }
    }

    public void bindServerListData(bse data, mt originalResponse) {
        if (this.extraServerListData.containsKey(originalResponse)) {
            JsonObject jsonData = this.extraServerListData.get(originalResponse);
            String type = jsonData.get("type").getAsString();
            JsonArray modDataArray = jsonData.get("modList").getAsJsonArray();
            boolean moddedClientAllowed = jsonData.has("clientModsAllowed") ? jsonData.get("clientModsAllowed").getAsBoolean() : true;
            ImmutableMap.Builder modListBldr = ImmutableMap.builder();
            for (JsonElement obj : modDataArray) {
                JsonObject modObj = obj.getAsJsonObject();
                modListBldr.put((Object)modObj.get("modid").getAsString(), (Object)modObj.get("version").getAsString());
            }
            ImmutableMap modListMap = modListBldr.build();
            String modRejections = FMLNetworkHandler.checkModList((Map<String, String>)modListMap, Side.SERVER);
            this.serverDataTag.put(data, new ExtendedServerListData(type, modRejections == null, (Map<String, String>)modListMap, !moddedClientAllowed));
        } else {
            String serverDescription = data.d;
            boolean moddedClientAllowed = true;
            if (!Strings.isNullOrEmpty((String)serverDescription)) {
                moddedClientAllowed = !serverDescription.endsWith(":NOFML\u00a7r");
            }
            this.serverDataTag.put(data, new ExtendedServerListData("VANILLA", false, (Map<String, String>)ImmutableMap.of(), !moddedClientAllowed));
        }
        startupConnectionData.countDown();
    }

    @Nullable
    public String enhanceServerListEntry(bni serverListEntry, bse serverEntry, int x, int width, int y, int relativeMouseX, int relativeMouseY) {
        String tooltip;
        int idx;
        ExtendedServerListData extendedData;
        boolean blocked = false;
        if (this.serverDataTag.containsKey(serverEntry)) {
            extendedData = this.serverDataTag.get(serverEntry);
            if ("FML".equals(extendedData.type) && extendedData.isCompatible) {
                idx = 0;
                tooltip = String.format("Compatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("FML".equals(extendedData.type) && !extendedData.isCompatible) {
                idx = 16;
                tooltip = String.format("Incompatible FML modded server\n%d mods present", extendedData.modData.size());
            } else if ("BUKKIT".equals(extendedData.type)) {
                idx = 32;
                tooltip = String.format("Bukkit modded server", new Object[0]);
            } else if ("VANILLA".equals(extendedData.type)) {
                idx = 48;
                tooltip = String.format("Vanilla server", new Object[0]);
            } else {
                idx = 64;
                tooltip = String.format("Unknown server data", new Object[0]);
            }
        } else {
            return null;
        }
        blocked = extendedData.isBlocked;
        this.client.N().a(iconSheet);
        bir.a((int)(x + width - 18), (int)(y + 10), (float)0.0f, (float)idx, (int)16, (int)16, (float)256.0f, (float)256.0f);
        if (blocked) {
            bir.a((int)(x + width - 18), (int)(y + 10), (float)0.0f, (float)80.0f, (int)16, (int)16, (float)256.0f, (float)256.0f);
        }
        return relativeMouseX > width - 15 && relativeMouseX < width && relativeMouseY > 10 && relativeMouseY < 26 ? tooltip : null;
    }

    public String fixDescription(String description) {
        return description.endsWith(":NOFML\u00a7r") ? description.substring(0, description.length() - 8) + "\u00a7r" : description;
    }

    public void connectToServerAtStartup(String host, int port) {
        this.setupServerList();
        bsg osp = new bsg();
        bse serverData = new bse("Command Line", host + ":" + port, false);
        try {
            osp.a(serverData);
            startupConnectionData.await(30L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.showGuiScreen(new bkr((blk)new blr(), this.client, host, port));
            return;
        }
        this.connectToServer((blk)new blr(), serverData);
    }

    public void connectToServer(blk guiMultiplayer, bse serverEntry) {
        ExtendedServerListData extendedData = this.serverDataTag.get(serverEntry);
        if (extendedData != null && extendedData.isBlocked) {
            this.showGuiScreen((Object)new GuiAccessDenied(guiMultiplayer, serverEntry));
        } else {
            this.showGuiScreen(new bkr(guiMultiplayer, this.client, serverEntry));
        }
    }

    public void connectToRealmsServer(String host, int port) {
    }

    public void setPlayClient(brz netHandlerPlayClient) {
        this.currentPlayClient = new WeakReference<brz>(netHandlerPlayClient);
    }

    @Override
    public void fireNetRegistrationEvent(EventBus bus2, gw manager, Set<String> channelSet, String channel, Side side) {
        if (side == Side.CLIENT) {
            bus2.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<brz>(manager, channelSet, channel, side, brz.class));
        } else {
            bus2.post(new FMLNetworkEvent.CustomPacketRegistrationEvent<pa>(manager, channelSet, channel, side, pa.class));
        }
    }

    @Override
    public boolean shouldAllowPlayerLogins() {
        return true;
    }

    @Override
    public void allowLogins() {
    }

    @Override
    public tr getWorldThread(hb net) {
        if (net instanceof hw || net instanceof mg || net instanceof mq) {
            return this.getClient();
        }
        if (net instanceof me || net instanceof ml || net instanceof kx || net instanceof mu) {
            return this.getServer();
        }
        throw new RuntimeException("Unknown INetHandler: " + String.valueOf(net));
    }

    public void trackMissingTexture(nf resourceLocation) {
        this.badTextureDomains.add(resourceLocation.b());
        this.missingTextures.put((Object)resourceLocation.b(), (Object)resourceLocation);
    }

    public void trackBrokenTexture(nf resourceLocation, String error) {
        this.badTextureDomains.add(resourceLocation.b());
        Set badType = (Set)this.brokenTextures.get((Object)resourceLocation.b(), (Object)error);
        if (badType == null) {
            badType = Sets.newHashSet();
            this.brokenTextures.put((Object)resourceLocation.b(), (Object)((String)MoreObjects.firstNonNull((Object)error, (Object)"Unknown error")), (Object)badType);
        }
        badType.add(resourceLocation);
    }

    public void logMissingTextureErrors() {
        if (this.missingTextures.isEmpty() && this.brokenTextures.isEmpty()) {
            return;
        }
        Logger logger = LogManager.getLogger((String)"FML.TEXTURE_ERRORS");
        logger.error(Strings.repeat((String)"+=", (int)25));
        logger.error("The following texture errors were found.");
        Map resManagers = (Map)ObfuscationReflectionHelper.getPrivateValue(cev.class, (cev)bib.z().O(), "field_110548_a");
        for (String resourceDomain : this.badTextureDomains) {
            Set missing = this.missingTextures.get((Object)resourceDomain);
            logger.error(Strings.repeat((String)"=", (int)50));
            logger.error("  DOMAIN {}", (Object)resourceDomain);
            logger.error(Strings.repeat((String)"-", (int)50));
            logger.error("  domain {} is missing {} texture{}", (Object)resourceDomain, (Object)missing.size(), (Object)(missing.size() != 1 ? "s" : ""));
            cei fallbackResourceManager = (cei)resManagers.get(resourceDomain);
            if (fallbackResourceManager == null) {
                logger.error("    domain {} is missing a resource manager - it is probably a side-effect of automatic texture processing", (Object)resourceDomain);
            } else {
                List resPacks = (List)ObfuscationReflectionHelper.getPrivateValue(cei.class, fallbackResourceManager, "field_110540_a");
                logger.error("    domain {} has {} location{}:", (Object)resourceDomain, (Object)resPacks.size(), (Object)(resPacks.size() != 1 ? "s" : ""));
                Iterator<Object> iterator = resPacks.iterator();
                while (iterator.hasNext()) {
                    cer resPack = (cer)iterator.next();
                    if (resPack instanceof FMLContainerHolder) {
                        FMLContainerHolder containerHolder = (FMLContainerHolder)resPack;
                        ModContainer fmlContainer = containerHolder.getFMLContainer();
                        logger.error("      mod {} resources at {}", (Object)fmlContainer.getModId(), (Object)fmlContainer.getSource().getPath());
                        continue;
                    }
                    if (resPack instanceof ced) {
                        ced resourcePack = (ced)resPack;
                        File resPath = (File)ObfuscationReflectionHelper.getPrivateValue(ced.class, resourcePack, "field_110597_b");
                        logger.error("      resource pack at path {}", (Object)resPath.getPath());
                        continue;
                    }
                    logger.error("      unknown resourcepack type {} : {}", (Object)resPack.getClass().getName(), (Object)resPack.b());
                }
            }
            logger.error(Strings.repeat((String)"-", (int)25));
            if (this.missingTextures.containsKey((Object)resourceDomain)) {
                logger.error("    The missing resources for domain {} are:", (Object)resourceDomain);
                for (nf rl2 : missing) {
                    logger.error("      {}", (Object)rl2.a());
                }
                logger.error(Strings.repeat((String)"-", (int)25));
            }
            if (!this.brokenTextures.containsRow((Object)resourceDomain)) {
                logger.error("    No other errors exist for domain {}", (Object)resourceDomain);
            } else {
                logger.error("    The following other errors were reported for domain {}:", (Object)resourceDomain);
                Map resourceErrs = this.brokenTextures.row((Object)resourceDomain);
                for (String error : resourceErrs.keySet()) {
                    logger.error(Strings.repeat((String)"-", (int)25));
                    logger.error("    Problem: {}", (Object)error);
                    for (nf rl3 : (Set)resourceErrs.get(error)) {
                        logger.error("      {}", (Object)rl3.a());
                    }
                }
            }
            logger.error(Strings.repeat((String)"=", (int)50));
        }
        logger.error(Strings.repeat((String)"+=", (int)25));
    }

    @Override
    public void processWindowMessages() {
        if (LWJGLUtil.getPlatform() != 3) {
            return;
        }
        if (!SplashProgress.mutex.tryAcquire()) {
            return;
        }
        Display.processMessages();
        SplashProgress.mutex.release();
    }

    @Override
    public String stripSpecialChars(String message) {
        return DISALLOWED_CHAR_MATCHER.removeFrom((CharSequence)rp.a((String)message));
    }

    @Override
    public void reloadRenderers() {
        this.client.g.a();
    }

    @Override
    public void fireSidedRegistryEvents() {
        MinecraftForge.EVENT_BUS.post(new ModelRegistryEvent());
    }

    @Override
    public CompoundDataFixer getDataFixer() {
        return (CompoundDataFixer)this.client.ai();
    }

    @Override
    public boolean isDisplayVSyncForced() {
        return SplashProgress.isDisplayVSyncForced;
    }

    @Override
    public void resetClientRecipeBook() {
        cih.rebuildTable();
    }

    @Override
    public void reloadSearchTrees() {
        this.client.ar();
        this.client.getSearchTreeManager().a(this.client.O());
    }

    @Override
    public void reloadCreativeSettings() {
        this.client.u.a();
    }

    private CloudRenderer getCloudRenderer() {
        if (this.cloudRenderer == null) {
            this.cloudRenderer = new CloudRenderer();
        }
        return this.cloudRenderer;
    }

    public void updateCloudSettings() {
        this.getCloudRenderer().checkSettings();
    }

    public boolean renderClouds(int cloudTicks, float partialTicks) {
        IRenderHandler renderer = this.client.f.s.getCloudRenderer();
        if (renderer != null) {
            renderer.render(partialTicks, this.client.f, this.client);
            return true;
        }
        return this.getCloudRenderer().render(cloudTicks, partialTicks);
    }

    public void refreshResources(IResourceType ... inclusion) {
        this.refreshResources(ReloadRequirements.include(inclusion));
    }

    public void refreshResources(Predicate<IResourceType> resourcePredicate) {
        SelectiveReloadStateHandler.INSTANCE.beginReload(resourcePredicate);
        this.client.f();
        SelectiveReloadStateHandler.INSTANCE.endReload();
    }

    public ListenableFuture<Object> scheduleResourcesRefresh(IResourceType ... inclusion) {
        return this.scheduleResourcesRefresh(ReloadRequirements.include(inclusion));
    }

    public ListenableFuture<Object> scheduleResourcesRefresh(Predicate<IResourceType> resourcePredicate) {
        return this.client.a(() -> this.refreshResources(resourcePredicate));
    }
}

