/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.toposort;

import java.util.Set;
import net.minecraftforge.fml.client.GuiSortingProblem;
import net.minecraftforge.fml.client.IDisplayableError;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModSortingException
extends EnhancedRuntimeException
implements IDisplayableError {
    private static final long serialVersionUID = 1L;
    private SortingExceptionData<?> sortingExceptionData;

    public <T> ModSortingException(String string, T node, Set<T> visitedNodes) {
        super(string);
        this.sortingExceptionData = new SortingExceptionData<T>(this, node, visitedNodes);
    }

    public <T> SortingExceptionData<T> getExceptionData() {
        return this.sortingExceptionData;
    }

    @Override
    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
        SortingExceptionData exceptionData = this.getExceptionData();
        stream.println("A dependency cycle was detected in the input mod set so an ordering cannot be determined");
        stream.println("The first mod in the cycle is " + String.valueOf(exceptionData.getFirstBadNode()));
        stream.println("The mod cycle involves:");
        for (ModContainer mc : exceptionData.getVisitedNodes()) {
            stream.println(String.format("\t%s : before: %s, after: %s", mc.toString(), mc.getDependants(), mc.getDependencies()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public blk createGui() {
        return new GuiSortingProblem(this);
    }

    public class SortingExceptionData<T> {
        private T firstBadNode;
        private Set<T> visitedNodes;

        public SortingExceptionData(ModSortingException this$0, T node, Set<T> visitedNodes) {
            this.firstBadNode = node;
            this.visitedNodes = visitedNodes;
        }

        public T getFirstBadNode() {
            return this.firstBadNode;
        }

        public Set<T> getVisitedNodes() {
            return this.visitedNodes;
        }
    }
}

