/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.versioning;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.relauncher.Side;

public final class DependencyParser {
    private static final ImmutableList<String> DEPENDENCY_INSTRUCTIONS = ImmutableList.of((Object)"client", (Object)"server", (Object)"required", (Object)"before", (Object)"after");
    private static final Splitter DEPENDENCY_INSTRUCTIONS_SPLITTER = Splitter.on((String)"-").omitEmptyStrings().trimResults();
    private static final Splitter DEPENDENCY_PART_SPLITTER = Splitter.on((String)":").omitEmptyStrings().trimResults();
    private static final Splitter DEPENDENCY_SPLITTER = Splitter.on((String)";").omitEmptyStrings().trimResults();
    private final String modId;
    private final Side side;

    public DependencyParser(String modId, Side side) {
        this.modId = modId;
        this.side = side;
    }

    public DependencyInfo parseDependencies(String dependencyString) {
        DependencyInfo info = new DependencyInfo();
        if (dependencyString == null || dependencyString.length() == 0) {
            return info;
        }
        for (String dep : DEPENDENCY_SPLITTER.split((CharSequence)dependencyString)) {
            List depParts = DEPENDENCY_PART_SPLITTER.splitToList((CharSequence)dep);
            if (depParts.size() != 2) {
                throw new DependencyParserException(this.modId, dep, "Dependency string needs 2 parts.");
            }
            List instructions = DEPENDENCY_INSTRUCTIONS_SPLITTER.splitToList((CharSequence)depParts.get(0));
            String target = (String)depParts.get(1);
            this.parseDependency(dep, instructions, target, info);
        }
        return info;
    }

    private void parseDependency(String dep, List<String> instructions, String target, DependencyInfo info) {
        ArtifactVersion artifactVersion;
        boolean targetIsAll = target.startsWith("*");
        boolean targetIsBounded = target.contains("@");
        if (targetIsAll) {
            if (target.length() > 1) {
                throw new DependencyParserException(this.modId, dep, "Cannot have an \"all\" (*) relationship with anything except pure *");
            }
            if (targetIsBounded) {
                throw new DependencyParserException(this.modId, dep, "You cannot have a versioned dependency on everything (*)");
            }
        }
        Side depSide = null;
        String depOrder = null;
        boolean depRequired = false;
        for (String instruction : instructions) {
            if ("client".equals(instruction)) {
                if (depSide != null) {
                    throw new DependencyParserException(this.modId, dep, "Up to one side (client or server) can be specified.");
                }
                depSide = Side.CLIENT;
                continue;
            }
            if ("server".equals(instruction)) {
                if (depSide != null) {
                    throw new DependencyParserException(this.modId, dep, "Up to one side (client or server) can be specified.");
                }
                depSide = Side.SERVER;
                continue;
            }
            if ("required".equals(instruction)) {
                if (depRequired) {
                    throw new DependencyParserException(this.modId, dep, "'required' can only be specified once.");
                }
                if (targetIsAll) {
                    throw new DependencyParserException(this.modId, dep, "You can't 'require' everything (*)");
                }
                depRequired = true;
                continue;
            }
            if ("before".equals(instruction) || "after".equals(instruction)) {
                if (depOrder != null) {
                    throw new DependencyParserException(this.modId, dep, "'before' or 'after' can only be specified once.");
                }
                depOrder = instruction;
                continue;
            }
            throw new DependencyParserException(this.modId, dep, String.format("Found invalid instruction '%s'. Only %s are allowed.", instruction, DEPENDENCY_INSTRUCTIONS));
        }
        try {
            artifactVersion = VersionParser.parseVersionReference(target);
        }
        catch (RuntimeException e2) {
            throw new DependencyParserException(this.modId, dep, "Could not parse version string.", e2);
        }
        if (!targetIsAll) {
            String depModId = artifactVersion.getLabel();
            DependencyParser.sanityCheckModId(this.modId, dep, depModId);
        }
        if (!depRequired && depOrder == null) {
            throw new DependencyParserException(this.modId, dep, "'required', 'client', or 'server' must be specified.");
        }
        if (depSide == null || depSide == this.side) {
            if (depRequired) {
                info.requirements.add(artifactVersion);
            }
            if ("before".equals(depOrder)) {
                info.dependants.add(artifactVersion);
            } else if ("after".equals(depOrder)) {
                info.dependencies.add(artifactVersion);
            }
        }
    }

    private static void sanityCheckModId(String modId, String dep, String depModId) {
        if (Strings.isNullOrEmpty((String)depModId)) {
            FMLLog.log.error(new DependencyParserException(modId, dep, "The modId is null or empty").getMessage());
        } else if (depModId.length() > 64) {
            FMLLog.log.error(new DependencyParserException(modId, dep, String.format("The modId '%s' is longer than the maximum of 64 characters.", depModId)).getMessage());
        } else if (!depModId.equals(depModId.toLowerCase(Locale.ENGLISH))) {
            FMLLog.log.error(new DependencyParserException(modId, dep, String.format("The modId '%s' must be all lowercase.", depModId)).getMessage());
        }
    }

    public static class DependencyInfo {
        public final Set<ArtifactVersion> requirements = new HashSet<ArtifactVersion>();
        public final List<ArtifactVersion> dependencies = new ArrayList<ArtifactVersion>();
        public final List<ArtifactVersion> dependants = new ArrayList<ArtifactVersion>();
    }

    private static class DependencyParserException
    extends LoaderException {
        public DependencyParserException(String modId, String dependencyString, String explanation) {
            super(DependencyParserException.formatMessage(modId, dependencyString, explanation));
        }

        public DependencyParserException(String modId, String dependencyString, String explanation, Throwable cause) {
            super(DependencyParserException.formatMessage(modId, dependencyString, explanation), cause);
        }

        public static String formatMessage(String modId, String dependencyString, String explanation) {
            return String.format("Unable to parse dependency for mod '%s' with dependency string '%s'. %s", modId, dependencyString, explanation);
        }
    }
}

