/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.spongepowered.asm.launch.GlobalProperties;
import org.spongepowered.asm.mixin.Mixins;
import zone.rong.mixinbooter.Context;
import zone.rong.mixinbooter.IEarlyMixinLoader;
import zone.rong.mixinbooter.IMixinConfigHijacker;

@IFMLLoadingPlugin.Name(value="MixinBooter")
@IFMLLoadingPlugin.MCVersion(value="1.12.2")
@IFMLLoadingPlugin.SortingIndex(value=1)
public final class MixinBooterPlugin
implements IFMLLoadingPlugin {
    static Set<IEarlyMixinLoader> earlyMixinLoaders = new HashSet<IEarlyMixinLoader>();

    @Override
    public void injectData(Map<String, Object> data) {
        MixinBooterPlugin.loadEarlyLoaders(earlyMixinLoaders);
        earlyMixinLoaders = null;
    }

    static void queneEarlyMixinLoader(IFMLLoadingPlugin plugin) {
        if (plugin instanceof IEarlyMixinLoader) {
            IEarlyMixinLoader earlyMixinLoader = (IEarlyMixinLoader)((Object)plugin);
            earlyMixinLoaders.add(earlyMixinLoader);
        }
        if (plugin instanceof IMixinConfigHijacker) {
            IMixinConfigHijacker hijacker = (IMixinConfigHijacker)((Object)plugin);
            Collection disabledConfigs = (Collection)GlobalProperties.get((GlobalProperties.Keys)GlobalProperties.Keys.CLEANROOM_DISABLE_MIXIN_CONFIGS);
            Context context = new Context(null, Collections.emptySet());
            FMLLog.log.info("Loading config hijacker {}.", (Object)hijacker.getClass().getName());
            for (String hijacked : hijacker.getHijackedMixinConfigs(context)) {
                disabledConfigs.add(hijacked);
                FMLLog.log.info("{} will hijack the mixin config {}", (Object)hijacker.getClass().getName(), (Object)hijacked);
            }
        }
    }

    private static void loadEarlyLoaders(Collection<IEarlyMixinLoader> queuedLoaders) {
        Set<String> modlist = MixinBooterPlugin.speculatedModList();
        for (IEarlyMixinLoader queuedLoader : queuedLoaders) {
            FMLLog.log.info("Loading early loader {} for its mixins.", (Object)queuedLoader.getClass().getName());
            for (String mixinConfig : queuedLoader.getMixinConfigs()) {
                Context context = new Context(mixinConfig, modlist);
                if (!queuedLoader.shouldMixinConfigQueue(context)) continue;
                FMLLog.log.info("Adding {} mixin configuration.", (Object)mixinConfig);
                Mixins.addConfiguration((String)mixinConfig);
                queuedLoader.onMixinConfigQueued(context);
            }
        }
    }

    public static Set<String> speculatedModList() {
        HashSet<String> presentMods = new HashSet<String>();
        presentMods.add("minecraft");
        presentMods.add("fml");
        presentMods.add("forge");
        presentMods.add("mixinbooter");
        presentMods.add("configanytime");
        try {
            Enumeration resources = Launch.classLoader.getResources("mcmod.info");
            while (resources.hasMoreElements()) {
                presentMods.addAll(MixinBooterPlugin.parseMcmodInfo((URL)resources.nextElement()));
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to gather present mods from mcmod.info (s)", e2);
        }
        if (Launch.classLoader.isClassExist("optifine.OptiFineTweaker")) {
            presentMods.add("optifine");
        }
        return presentMods;
    }

    private static Set<String> parseMcmodInfo(URL url) {
        try {
            HashSet<String> ids = new HashSet<String>();
            JsonElement root = JsonParser.parseReader((Reader)new InputStreamReader(url.openStream()));
            if (root.isJsonArray()) {
                for (JsonElement element : root.getAsJsonArray()) {
                    if (!element.isJsonObject()) continue;
                    ids.add(element.getAsJsonObject().get("modid").getAsString());
                }
            } else {
                for (JsonElement element : root.getAsJsonObject().get("modList").getAsJsonArray()) {
                    if (!element.isJsonObject()) continue;
                    ids.add(element.getAsJsonObject().get("modid").getAsString());
                }
            }
            return ids;
        }
        catch (Throwable t) {
            FMLLog.log.error("Failed to parse mcmod.info for " + String.valueOf(url), t);
            return Collections.emptySet();
        }
    }
}

