/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.property;

import com.google.common.base.Predicate;
import com.google.common.primitives.Floats;
import com.google.gson.JsonObject;
import mod.bespectacled.modernbetaforge.api.property.PropertyGuiType;
import mod.bespectacled.modernbetaforge.api.property.RangedProperty;
import mod.bespectacled.modernbetaforge.property.visitor.EntryValuePropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.FactoryPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.GuiPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.PropertyVisitor;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public final class FloatProperty
extends RangedProperty<Float> {
    public FloatProperty(float value, float minValue, float maxValue, PropertyGuiType guiType) {
        super(Float.valueOf(value), Float.valueOf(minValue), Float.valueOf(maxValue), guiType);
    }

    public FloatProperty(float value) {
        this(value, Float.MIN_VALUE, Float.MAX_VALUE, PropertyGuiType.FIELD);
    }

    @Override
    public void setValue(Float value) {
        super.setValue(Float.valueOf(MathHelper.func_76131_a((float)value.floatValue(), (float)((Float)this.getMinValue()).floatValue(), (float)((Float)this.getMaxValue()).floatValue())));
    }

    @Override
    public String getType() {
        return "float";
    }

    @Override
    public void visitFactory(FactoryPropertyVisitor visitor, ModernBetaGeneratorSettings.Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
        visitor.visit(this, factory, registryKey, jsonObject);
    }

    @Override
    public GuiPageButtonList.GuiListEntry visitGui(GuiPropertyVisitor visitor, int guiIdentifier) {
        return visitor.visit(this, guiIdentifier);
    }

    @Override
    public void visitEntryValue(EntryValuePropertyVisitor visitor, int guiIdentifier, Object value, ResourceLocation registryKey) {
        visitor.visit(this, guiIdentifier, value, registryKey);
    }

    @Override
    public String visitNameFormatter(PropertyVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getFormatter() {
        return "%2.3f";
    }

    public Predicate<String> getStringPredicate() {
        return string -> {
            Float value = Floats.tryParse((String)string);
            return string.isEmpty() || string.equals("-") || value != null && Floats.isFinite((float)value.floatValue());
        };
    }
}

