/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.property;

import com.google.common.base.Predicate;
import com.google.common.primitives.Ints;
import com.google.gson.JsonObject;
import mod.bespectacled.modernbetaforge.api.property.PropertyGuiType;
import mod.bespectacled.modernbetaforge.api.property.RangedProperty;
import mod.bespectacled.modernbetaforge.property.visitor.EntryValuePropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.FactoryPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.GuiPropertyVisitor;
import mod.bespectacled.modernbetaforge.property.visitor.PropertyVisitor;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public final class IntProperty
extends RangedProperty<Integer> {
    public IntProperty(int value, int minValue, int maxValue, PropertyGuiType guiType) {
        super(value, minValue, maxValue, guiType);
    }

    public IntProperty(int value) {
        this(value, Integer.MIN_VALUE, Integer.MAX_VALUE, PropertyGuiType.FIELD);
    }

    @Override
    public void setValue(Integer value) {
        super.setValue(MathHelper.func_76125_a((int)value, (int)((Integer)this.getMinValue()), (int)((Integer)this.getMaxValue())));
    }

    @Override
    public String getType() {
        return "int";
    }

    @Override
    public void visitFactory(FactoryPropertyVisitor visitor, ModernBetaGeneratorSettings.Factory factory, ResourceLocation registryKey, JsonObject jsonObject) {
        visitor.visit(this, factory, registryKey, jsonObject);
    }

    @Override
    public GuiPageButtonList.GuiListEntry visitGui(GuiPropertyVisitor visitor, int guiIdentifier) {
        return visitor.visit(this, guiIdentifier);
    }

    @Override
    public void visitEntryValue(EntryValuePropertyVisitor visitor, int guiIdentifier, Object value, ResourceLocation registryKey) {
        visitor.visit(this, guiIdentifier, value, registryKey);
    }

    @Override
    public String visitNameFormatter(PropertyVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public String getFormatter() {
        return "%d";
    }

    public Predicate<String> getStringPredicate() {
        return string -> {
            Integer value = Ints.tryParse((String)string);
            return string.isEmpty() || string.equals("-") || value != null;
        };
    }
}

