/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.biome;

import mod.bespectacled.modernbetaforge.api.world.biome.BiomeResolverCustom;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.world.biome.climate.SimpleClimateSampler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class BiomeResolverAddSingleBiome
implements BiomeResolverCustom {
    private final Biome biome;
    private final SimpleClimateSampler climateSampler;
    private final float chance;

    public BiomeResolverAddSingleBiome(ResourceLocation biome, long seed, long climateSeed, long detailSeed, float chance) {
        this((Biome)ForgeRegistryUtil.get(biome, ForgeRegistries.BIOMES), seed, climateSeed, detailSeed, chance);
    }

    public BiomeResolverAddSingleBiome(Biome biome, long seed, long climateSeed, long detailSeed, float chance) {
        this.biome = biome;
        this.climateSampler = new SimpleClimateSampler(seed, climateSeed, detailSeed);
        this.chance = MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
    }

    @Override
    public Biome getCustomBiome(int x, int z) {
        if ((double)this.chance <= 0.0) {
            return null;
        }
        if (this.climateSampler.sample(x, z) <= (double)this.chance) {
            return this.biome;
        }
        return null;
    }
}

