/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.noise;

import mod.bespectacled.modernbetaforge.util.MathUtil;

public class NoiseSettings {
    public final int sizeVertical;
    public final int sizeHorizontal;
    public final SlideSettings topSlideSettings;
    public final SlideSettings bottomSlideSettings;

    public NoiseSettings(int sizeVertical, int sizeHorizontal, SlideSettings topSlideSettings, SlideSettings bottomSlideSettings) {
        this.sizeVertical = sizeVertical;
        this.sizeHorizontal = sizeHorizontal;
        this.topSlideSettings = topSlideSettings;
        this.bottomSlideSettings = bottomSlideSettings;
    }

    public static class SlideSettings {
        public final int slideTarget;
        public final int slideSize;
        public final int slideOffset;

        public SlideSettings(int slideTarget, int slideSize, int slideOffset) {
            this.slideTarget = slideTarget;
            this.slideSize = slideSize;
            this.slideOffset = slideOffset;
        }

        public double applyTopSlide(double density, int noiseY, int noiseSizeY) {
            if ((double)this.slideSize > 0.0) {
                double delta = ((double)(noiseSizeY - noiseY) - (double)this.slideOffset) / (double)this.slideSize;
                density = MathUtil.clampedLerp(this.slideTarget, density, delta);
            }
            return density;
        }

        public double applyBottomSlide(double density, int noiseY) {
            if ((double)this.slideSize > 0.0) {
                double delta = ((double)noiseY - (double)this.slideOffset) / (double)this.slideSize;
                density = MathUtil.clampedLerp(this.slideTarget, density, delta);
            }
            return density;
        }
    }
}

