/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.api.world.chunk.surface;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.compat.Compat;
import mod.bespectacled.modernbetaforge.compat.ModCompat;
import mod.bespectacled.modernbetaforge.compat.SurfaceCompat;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.util.ForgeRegistryUtil;
import mod.bespectacled.modernbetaforge.util.noise.SimplexOctaveNoise;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeLists;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public abstract class SurfaceBuilder {
    protected final IBlockState defaultBlock;
    protected final IBlockState defaultFluid;
    protected final ChunkSource chunkSource;
    protected final ModernBetaGeneratorSettings settings;
    private final SimplexOctaveNoise surfaceOctaveNoise;
    private final Set<Biome> biomesWithCustomSurfaces = new HashSet<Biome>(ModernBetaBiomeLists.BUILTIN_BIOMES_WITH_CUSTOM_SURFACES);

    public SurfaceBuilder(ChunkSource chunkSource, ModernBetaGeneratorSettings settings) {
        this.defaultBlock = chunkSource.getDefaultBlock();
        this.defaultFluid = chunkSource.getDefaultFluid();
        this.chunkSource = chunkSource;
        this.settings = settings;
        Random random = new Random(chunkSource.getSeed());
        this.surfaceOctaveNoise = new SimplexOctaveNoise(random, 4);
        this.biomesWithCustomSurfaces.addAll(Arrays.asList(ModernBetaConfig.generatorOptions.biomesWithCustomSurfaces).stream().map(id -> (Biome)ForgeRegistryUtil.get(new ResourceLocation(id), ForgeRegistries.BIOMES)).collect(Collectors.toList()));
        for (Map.Entry<String, Compat> entry : ModCompat.LOADED_MODS.entrySet()) {
            Compat compat = entry.getValue();
            if (!(compat instanceof SurfaceCompat)) continue;
            SurfaceCompat surfaceCompat = (SurfaceCompat)((Object)compat);
            this.biomesWithCustomSurfaces.addAll(surfaceCompat.getBiomesWithCustomSurfaces());
        }
    }

    public abstract void provideSurface(World var1, Biome[] var2, ChunkPrimer var3, int var4, int var5);

    public boolean isBedrock(int y, Random random) {
        return this.useBedrock() && y <= random.nextInt(5);
    }

    public Random createSurfaceRandom(int chunkX, int chunkZ) {
        long seed = (long)chunkX * 341873128712L + (long)chunkZ * 132897987541L;
        return new Random(seed);
    }

    public boolean isCustomSurface(Biome biome) {
        return this.biomesWithCustomSurfaces.contains(biome);
    }

    protected int getWorldHeight() {
        return this.settings.height;
    }

    protected int getSeaLevel() {
        return this.chunkSource.getSeaLevel();
    }

    protected boolean useSandstone() {
        return this.settings.useSandstone;
    }

    protected boolean useBedrock() {
        return true;
    }

    protected boolean useCustomSurfaceBuilder(World world, Biome biome, ChunkPrimer chunkPrimer, Random random, int x, int z, boolean override) {
        if (this.biomesWithCustomSurfaces.contains(biome) || override) {
            double surfaceNoise = this.surfaceOctaveNoise.sample(x, z, 0.0625, 0.0625, 1.0);
            biome.func_180622_a(world, random, chunkPrimer, z, x, surfaceNoise);
            return true;
        }
        return false;
    }
}

