/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.client.gui;

import com.google.common.primitives.Longs;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.api.registry.ModernBetaRegistries;
import mod.bespectacled.modernbetaforge.api.world.biome.source.BiomeSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.ChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.source.FiniteChunkSource;
import mod.bespectacled.modernbetaforge.api.world.chunk.surface.SurfaceBuilder;
import mod.bespectacled.modernbetaforge.client.color.BetaColorSampler;
import mod.bespectacled.modernbetaforge.client.gui.GuiBoundsChecker;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizeWorld;
import mod.bespectacled.modernbetaforge.util.DrawUtil;
import mod.bespectacled.modernbetaforge.util.ExecutorWrapper;
import mod.bespectacled.modernbetaforge.util.MathUtil;
import mod.bespectacled.modernbetaforge.util.chunk.HeightmapChunk;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionRules;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiScreenCustomizePreview
extends GuiScreen
implements GuiPageButtonList.GuiResponder,
GuiSlider.FormatHelper {
    private static final String PREFIX = "createWorld.customize.preview.modernbetaforge.";
    private static final int TEXTURE_Y_OFFSET = 10;
    private static final int HINT_TEXT_OFFSET = 22;
    private static final int PROGRESS_TEXT_OFFSET = 5;
    private static final int RGB_WHITE = 0xFFFFFF;
    private static final int RGB_YELLOW = 0xFFFFA0;
    private static final int RGB_GREY = 0xA0A0A0;
    private static final int ARGB_BORDER_LIGHT = -2039584;
    private static final int ARGB_BORDER_DARK = -6250336;
    private static final int ARGB_PREVIEW_BOX = MathUtil.convertARGBComponentsToInt(50, 0, 0, 0);
    private static final int ARGB_PROGRESS_BOX = MathUtil.convertARGBComponentsToInt(200, 0, 0, 0);
    private static final int ARGB_PROGRESS_BAR = MathUtil.convertARGBComponentsToInt(160, 128, 255, 128);
    private static final int GUI_ID_BIOME_COLORS = 0;
    private static final int GUI_ID_RESOLUTION = 1;
    private static final int GUI_ID_GENERATE = 2;
    private static final int GUI_ID_CANCEL = 3;
    private static final long COPIED_SEED_WAIT_TIME = 1000L;
    private final GuiScreenCustomizeWorld parent;
    private final String worldSeed;
    private final ModernBetaGeneratorSettings settings;
    private final ExecutorWrapper executor;
    private final GuiBoundsChecker mapBounds;
    private final GuiBoundsChecker seedFieldBounds;
    private long seed;
    private ChunkSource chunkSource;
    private BiomeSource biomeSource;
    private SurfaceBuilder surfaceBuilder;
    private BiomeInjectionRules injectionRules;
    private GuiListButton buttonBiomeBlend;
    private GuiSlider sliderResolution;
    private GuiButton buttonGenerate;
    private GuiButton buttonCancel;
    private ListPreset list;
    private ProgressState state;
    private int resolution;
    private boolean useBiomeBlend;
    private float progress;
    private float prevProgress;
    private MapTexture prevMapTexture;
    private MapTexture mapTexture;
    private boolean hoveredSeedField;
    private boolean hoveredMap;
    private boolean copiedSeedField;
    private boolean copiedTpCommand;
    private long copiedSeedFieldTime;
    private long copiedTpCommandTime;
    private Supplier<String> tpCallback;
    protected String title = I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.title", (Object[])new Object[0]);

    public GuiScreenCustomizePreview(GuiScreenCustomizeWorld parent, String worldSeed, ModernBetaGeneratorSettings settings) {
        this.parent = parent;
        this.worldSeed = worldSeed;
        this.settings = settings;
        this.executor = new ExecutorWrapper(1, "map_preview");
        this.mapBounds = new GuiBoundsChecker();
        this.seedFieldBounds = new GuiBoundsChecker();
        this.seed = GuiScreenCustomizePreview.parseSeed(worldSeed);
        this.initSources(this.seed, settings);
        this.state = ProgressState.NOT_STARTED;
        this.resolution = 512;
        this.useBiomeBlend = true;
        this.progress = 0.0f;
        this.mapTexture = new MapTexture(this, ModernBeta.createRegistryKey("map_preview"));
    }

    public void func_73866_w_() {
        int resolutionNdx = GuiScreenCustomizePreview.getNdx(ModernBetaGeneratorSettings.LEVEL_WIDTHS, this.resolution);
        this.field_146292_n.clear();
        this.buttonBiomeBlend = (GuiListButton)this.func_189646_b((GuiButton)new GuiListButton((GuiPageButtonList.GuiResponder)this, 0, this.field_146294_l / 2 - 187, this.field_146295_m - 27, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.biomeBlend", (Object[])new Object[0]), true));
        this.sliderResolution = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider((GuiPageButtonList.GuiResponder)this, 1, this.field_146294_l / 2 - 92, this.field_146295_m - 27, "createWorld.customize.preview.modernbetaforge.resolution", 2.0f, (float)(ModernBetaGeneratorSettings.LEVEL_WIDTHS.length - 1), (float)resolutionNdx, (GuiSlider.FormatHelper)this));
        this.buttonGenerate = this.func_189646_b(new GuiButton(2, this.field_146294_l / 2 + 3, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.generate", (Object[])new Object[0])));
        this.buttonCancel = this.func_189646_b(new GuiButton(3, this.field_146294_l / 2 + 98, this.field_146295_m - 27, 90, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.buttonBiomeBlend.field_146120_f = 90;
        this.sliderResolution.field_146120_f = 90;
        this.buttonBiomeBlend.func_175212_b(this.useBiomeBlend);
        this.list = new ListPreset(this);
        int viewportSize = Math.min(this.list.field_148158_l, this.list.field_148155_a) - 32 - 32 - 32;
        int textureX = this.field_146294_l / 2 - viewportSize / 2;
        int textureY = this.field_146295_m / 2 - viewportSize / 2;
        this.mapBounds.updateBounds(textureX, textureY -= 10, viewportSize, viewportSize);
        this.seedFieldBounds.updateBounds(this.getSeedFieldX(), this.getSeedFieldY(), this.getSeedFieldWidth(), this.field_146289_q.field_78288_b);
        this.updateButtonsEnabled(this.state);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        this.hoveredSeedField = this.seedFieldBounds.inBounds(mouseX, mouseY);
        this.hoveredMap = this.mapBounds.inBounds(mouseX, mouseY);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.list.func_148128_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 14, 0xFFFFFF);
        if (System.currentTimeMillis() - this.copiedSeedFieldTime > 1000L) {
            this.copiedSeedField = false;
        }
        if (System.currentTimeMillis() - this.copiedTpCommandTime > 1000L) {
            this.copiedTpCommand = false;
        }
        int viewportSize = Math.min(this.list.field_148158_l, this.list.field_148155_a) - 32 - 32 - 32;
        int textureX = this.field_146294_l / 2 - viewportSize / 2;
        int textureY = this.field_146295_m / 2 - viewportSize / 2;
        textureY -= 10;
        int boxL = this.field_146294_l / 2 - 60;
        int boxR = this.field_146294_l / 2 + 60;
        int boxT = this.field_146295_m / 2 - 22 - 8;
        int boxB = this.field_146295_m / 2 - 5 + 18;
        int progressHeight = this.field_146295_m / 2 - 5;
        int progressBarLength = boxR - boxL - 20;
        int progressBarL = boxL + 10;
        int progressBarR = progressBarL + progressBarLength;
        this.prevProgress = MathUtil.lerp(partialTicks, this.prevProgress, this.progress);
        int progressLength = (int)((float)progressBarLength * this.prevProgress);
        GuiScreenCustomizePreview.func_73734_a((int)textureX, (int)textureY, (int)(textureX + viewportSize), (int)(textureY + viewportSize), (int)ARGB_PREVIEW_BOX);
        this.func_73730_a(textureX - 1, textureX + viewportSize, textureY - 1, -2039584);
        this.func_73730_a(textureX - 1, textureX + viewportSize, textureY + viewportSize, -6250336);
        this.func_73728_b(textureX - 1, textureY - 1, textureY + viewportSize, -2039584);
        this.func_73728_b(textureX + viewportSize, textureY - 1, textureY + viewportSize, -6250336);
        switch (this.state) {
            case SUCCEEDED: {
                this.mapTexture.loadMapTexture();
                this.state = ProgressState.LOADED;
            }
            case LOADED: {
                this.prevMapTexture.lerpAlpha(partialTicks, 0.5f, 0.0f);
                if (this.mapTexture.mapAlpha < 1.0f) {
                    this.prevMapTexture.drawMapTexture(textureX, textureY, viewportSize);
                    this.mapTexture.lerpAlpha(partialTicks, 0.75f, 1.0f);
                }
                this.mapTexture.drawMapTexture(textureX, textureY, viewportSize);
                break;
            }
            case STARTED: {
                if (this.prevMapTexture.mapTexture != null) {
                    this.prevMapTexture.drawMapTexture(textureX, textureY, viewportSize);
                    GuiScreenCustomizePreview.func_73734_a((int)boxL, (int)boxT, (int)boxR, (int)boxB, (int)ARGB_PROGRESS_BOX);
                }
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.progress", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 22, 0xFFFFFF);
                if (this.chunkSource instanceof FiniteChunkSource && !((FiniteChunkSource)this.chunkSource).hasPregenerated()) {
                    String levelProgressText = ((FiniteChunkSource)this.chunkSource).getPhase();
                    if (levelProgressText == null) break;
                    this.func_73732_a(this.field_146289_q, levelProgressText + "..", this.field_146294_l / 2, progressHeight, 0xFFFFFF);
                    break;
                }
                GuiScreenCustomizePreview.func_73734_a((int)progressBarL, (int)(progressHeight + 9), (int)(progressBarL + progressLength), (int)(progressHeight - 2), (int)ARGB_PROGRESS_BAR);
                this.func_73730_a(progressBarL - 2, progressBarR + 1, progressHeight - 4, -2039584);
                this.func_73730_a(progressBarL - 2, progressBarR + 1, progressHeight + 10, -6250336);
                this.func_73728_b(progressBarL - 2, progressHeight + 10, progressHeight - 4, -2039584);
                this.func_73728_b(progressBarR + 1, progressHeight + 10, progressHeight - 4, -6250336);
                this.func_73732_a(this.field_146289_q, String.format("%d%%", (int)((double)this.progress * 100.0)), this.field_146294_l / 2, progressHeight, 0xFFFFFF);
                break;
            }
            case FAILED: {
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.failure", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 22, 0xFFFFFF);
                break;
            }
            default: {
                this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.hint", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 2 - 22, 0xFFFFFF);
            }
        }
        String seedPrefix = this.worldSeed.isEmpty() ? "Random " : "";
        String seedLabel = String.format("%s%s: ", seedPrefix, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.seed", (Object[])new Object[0]));
        String seedField = this.getFormattedSeed();
        int seedTextLen = this.field_146289_q.func_78256_a(seedLabel + seedField);
        int seedFieldLen = this.field_146289_q.func_78256_a(seedField);
        int seedColor = this.hoveredSeedField ? (System.currentTimeMillis() - this.copiedSeedFieldTime < 100L ? 0xA0A0A0 : 0xFFFFA0) : 0xFFFFFF;
        int seedFieldX = this.field_146294_l / 2 + seedTextLen / 2 - seedFieldLen;
        int seedFieldHeight = this.field_146295_m / 2 + viewportSize / 2;
        this.func_73731_b(this.field_146289_q, seedLabel, this.field_146294_l / 2 - seedTextLen / 2, seedFieldHeight, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, seedField, seedFieldX, seedFieldHeight, seedColor);
        int seedUnderlineShadow = MathUtil.convertRGBtoARGB(0x3F3F3F);
        int seedUnderline = MathUtil.convertRGBtoARGB(seedColor);
        if (!seedField.isEmpty()) {
            this.func_73730_a(seedFieldX + 1, seedFieldX + seedFieldLen + 1, seedFieldHeight + this.field_146289_q.field_78288_b + 1, seedUnderlineShadow);
            this.func_73730_a(seedFieldX, seedFieldX + seedFieldLen, seedFieldHeight + this.field_146289_q.field_78288_b, seedUnderline);
        }
        if (this.hoveredSeedField && !this.copiedSeedField && !this.copiedTpCommand) {
            this.func_146279_a(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copy", (Object[])new Object[0]), mouseX, mouseY);
        } else if (this.copiedSeedField) {
            this.func_146279_a(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copied", (Object[])new Object[0]), mouseX, mouseY);
        } else if (this.copiedTpCommand) {
            this.func_146279_a(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copiedTp", (Object[])new Object[0]), mouseX, mouseY);
        }
        if (this.state == ProgressState.LOADED && this.mapBounds.inBounds(mouseX, mouseY)) {
            float x = (float)this.mapBounds.getRelativeX(mouseX) / (float)viewportSize * (float)this.resolution;
            float y = (float)this.mapBounds.getRelativeY(mouseY) / (float)viewportSize * (float)this.resolution;
            int height = this.chunkSource.getHeight((int)(x -= (float)this.resolution / 2.0f), (int)(y -= (float)this.resolution / 2.0f), HeightmapChunk.Type.SURFACE);
            Biome biome = this.biomeSource.getBiome((int)x, (int)y);
            BiomeInjectionRules.BiomeInjectionContext context = DrawUtil.createInjectionContext(this.chunkSource, this.surfaceBuilder, (int)x, (int)y, biome);
            Biome injectedBiome = this.injectionRules.test(context, (int)x, (int)y, BiomeInjectionStep.PRE_SURFACE);
            biome = injectedBiome != null ? injectedBiome : biome;
            context.setBiome(biome);
            injectedBiome = this.injectionRules.test(context, (int)x, (int)y, BiomeInjectionStep.CUSTOM);
            biome = injectedBiome != null ? injectedBiome : biome;
            context.setBiome(biome);
            injectedBiome = this.injectionRules.test(context, (int)x, (int)y, BiomeInjectionStep.POST_SURFACE);
            biome = injectedBiome != null ? injectedBiome : biome;
            String coordinateText = String.format("%d, %d, %d", (int)x, height, (int)y);
            String biomeText = biome.func_185359_l();
            int tpX = (int)x;
            int tpZ = (int)y;
            int tpHeight = height < this.chunkSource.getSeaLevel() ? this.chunkSource.getSeaLevel() : height + 1;
            this.tpCallback = () -> String.format("/tp %d %d %d", tpX, tpHeight, tpZ);
            if (!this.copiedSeedField && !this.copiedTpCommand) {
                ArrayList<String> tooltips = new ArrayList<String>();
                tooltips.add(coordinateText);
                tooltips.add(biomeText);
                this.func_146283_a(tooltips, mouseX, mouseY);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public String func_175318_a(int id, String entryString, float entryValue) {
        if (id == 1) {
            return String.format("%s: %d", entryString, ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)entryValue]);
        }
        return String.format("%d", (int)entryValue);
    }

    public void func_175321_a(int id, boolean value) {
        if (id == 0) {
            this.useBiomeBlend = value;
        }
    }

    public void func_175320_a(int id, float value) {
        if (id == 1) {
            this.resolution = ModernBetaGeneratorSettings.LEVEL_WIDTHS[(int)value];
        }
    }

    public void func_175319_a(int id, String value) {
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 && this.state == ProgressState.STARTED) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.hoveredSeedField) {
            GuiScreen.func_146275_d((String)this.getFormattedSeed());
            ModernBeta.log(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copied", (Object[])new Object[0]));
            this.copiedSeedField = true;
            this.copiedSeedFieldTime = System.currentTimeMillis();
            this.copiedTpCommand = false;
        }
        if (mouseButton == 0 && this.hoveredMap && this.state == ProgressState.LOADED) {
            if (this.tpCallback != null) {
                GuiScreen.func_146275_d((String)this.tpCallback.get());
            }
            ModernBeta.log(I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.copiedTp", (Object[])new Object[0]));
            this.copiedTpCommand = true;
            this.copiedTpCommandTime = System.currentTimeMillis();
            this.copiedSeedField = false;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        switch (guiButton.field_146127_k) {
            case 2: {
                this.createTerrainMap();
                break;
            }
            case 3: {
                this.executor.shutdown();
                this.unloadMapTexture(this.mapTexture);
                this.unloadMapTexture(this.prevMapTexture);
                this.field_146297_k.func_147108_a((GuiScreen)this.parent);
            }
        }
    }

    private void createTerrainMap() {
        this.progress = 0.0f;
        this.prevProgress = 0.0f;
        this.state = ProgressState.STARTED;
        this.updateButtonsEnabled(this.state);
        long time = System.currentTimeMillis();
        this.unloadMapTexture(this.prevMapTexture);
        this.prevMapTexture = new MapTexture(this, this.mapTexture.mapIdentifier, this.mapTexture.mapImage, this.mapTexture.mapTexture, 1.0f);
        this.mapTexture = new MapTexture(this, ModernBeta.createRegistryKey("map_preview_" + new Random().nextLong()));
        if (this.worldSeed.isEmpty()) {
            this.seed = new Random().nextLong();
            this.initSources(this.seed, this.settings);
            this.seedFieldBounds.updateBounds(this.getSeedFieldX(), this.getSeedFieldY(), this.getSeedFieldWidth(), this.field_146289_q.field_78288_b);
        }
        Runnable runnable = () -> {
            try {
                ModernBeta.log(Level.DEBUG, String.format("Drawing terrain map of size %s", this.resolution));
                BetaColorSampler.INSTANCE.resetClimateSamplers();
                this.mapTexture.loadMapImage(DrawUtil.createTerrainMap(this.chunkSource, this.biomeSource, this.surfaceBuilder, this.injectionRules, this.resolution, this.useBiomeBlend, current -> {
                    this.progress = current.floatValue();
                }));
                ModernBeta.log(Level.DEBUG, String.format("Finished drawing terrain map in %2.3fs!", Float.valueOf((float)(System.currentTimeMillis() - time) / 1000.0f)));
                this.state = ProgressState.SUCCEEDED;
            }
            catch (Exception e) {
                ModernBeta.log(Level.ERROR, "Failed to draw terrain map!");
                ModernBeta.log(Level.ERROR, "Error: " + e.getLocalizedMessage());
                this.state = ProgressState.FAILED;
            }
            finally {
                this.updateButtonsEnabled(this.state);
            }
        };
        this.executor.queueRunnable(runnable);
    }

    private void unloadMapTexture(MapTexture mapTexture) {
        if (mapTexture != null) {
            mapTexture.unloadAll();
        }
    }

    private void updateButtonsEnabled(ProgressState state) {
        boolean enabled;
        this.buttonBiomeBlend.field_146124_l = enabled = state != ProgressState.STARTED;
        this.sliderResolution.field_146124_l = enabled;
        this.buttonGenerate.field_146124_l = enabled;
        this.buttonCancel.field_146124_l = enabled;
    }

    private void initSources(long seed, ModernBetaGeneratorSettings settings) {
        this.chunkSource = ModernBetaRegistries.CHUNK_SOURCE.get(settings.chunkSource).apply(seed, settings);
        this.biomeSource = ModernBetaRegistries.BIOME_SOURCE.get(settings.biomeSource).apply(seed, settings);
        this.surfaceBuilder = ModernBetaRegistries.SURFACE_BUILDER.get(settings.surfaceBuilder).apply(this.chunkSource, settings);
        this.injectionRules = this.chunkSource.buildBiomeInjectorRules(this.biomeSource);
    }

    private String getFormattedSeed() {
        return this.worldSeed.isEmpty() ? (this.state == ProgressState.NOT_STARTED ? "" : new Long(this.seed).toString()) : this.worldSeed;
    }

    private int getSeedFieldX() {
        String seedPrefix = this.worldSeed.isEmpty() ? "Random " : "";
        String seedLabel = String.format("%s%s: ", seedPrefix, I18n.func_135052_a((String)"createWorld.customize.preview.modernbetaforge.seed", (Object[])new Object[0]));
        String seedField = this.getFormattedSeed();
        int seedTextLen = this.field_146289_q.func_78256_a(seedLabel + seedField);
        int seedFieldLen = this.field_146289_q.func_78256_a(seedField);
        return this.field_146294_l / 2 + seedTextLen / 2 - seedFieldLen;
    }

    private int getSeedFieldY() {
        int viewportSize = Math.min(this.list.field_148158_l, this.list.field_148155_a) - 32 - 32 - 32;
        return this.field_146295_m / 2 + viewportSize / 2;
    }

    private int getSeedFieldWidth() {
        return this.field_146289_q.func_78256_a(this.getFormattedSeed());
    }

    private static long parseSeed(String seedString) {
        long seed = new Random().nextLong();
        if (!seedString.isEmpty()) {
            try {
                seed = Longs.tryParse((String)seedString);
            }
            catch (Exception e) {
                seed = seedString.hashCode();
            }
        }
        return seed;
    }

    private static int getNdx(int[] arr, int val) {
        for (int i = 0; i < arr.length; ++i) {
            if (val != arr[i]) continue;
            return i;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    private static class MapTexture {
        private final GuiScreenCustomizePreview parent;
        private final ResourceLocation mapIdentifier;
        private BufferedImage mapImage;
        private DynamicTexture mapTexture;
        private float mapAlpha;

        public MapTexture(GuiScreenCustomizePreview parent, ResourceLocation mapIdentifier) {
            this(parent, mapIdentifier, null, null, 0.0f);
        }

        public MapTexture(GuiScreenCustomizePreview parent, ResourceLocation mapIdentifier, BufferedImage mapImage, DynamicTexture mapTexture, float mapAlpha) {
            this.parent = parent;
            this.mapIdentifier = mapIdentifier;
            this.mapImage = mapImage;
            this.mapTexture = mapTexture;
            this.mapAlpha = mapAlpha;
        }

        public void loadMapImage(BufferedImage mapImage) {
            this.mapImage = mapImage;
        }

        public void loadMapTexture() {
            int mapWidth = this.mapImage.getWidth();
            int mapHeight = this.mapImage.getHeight();
            this.mapTexture = new DynamicTexture(mapWidth, mapHeight);
            this.parent.field_146297_k.func_110434_K().func_110579_a(this.mapIdentifier, (ITextureObject)this.mapTexture);
            this.mapImage.getRGB(0, 0, mapWidth, mapHeight, this.mapTexture.func_110565_c(), 0, mapWidth);
            this.mapTexture.func_110564_a();
            this.unloadMapImage();
        }

        public void unloadMapImage() {
            this.mapImage = null;
        }

        public void unloadMapTexture() {
            this.parent.field_146297_k.func_110434_K().func_147645_c(this.mapIdentifier);
            this.mapTexture = null;
        }

        public void unloadAll() {
            this.unloadMapImage();
            this.unloadMapTexture();
        }

        public void drawMapTexture(int textureX, int textureY, int viewportSize) {
            int width = this.parent.field_146294_l;
            int height = this.parent.field_146295_m;
            if (this.mapTexture != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mapAlpha);
                this.parent.field_146297_k.func_110434_K().func_110577_a(this.mapIdentifier);
                GlStateManager.func_179147_l();
                Gui.func_146110_a((int)textureX, (int)textureY, (float)0.0f, (float)0.0f, (int)viewportSize, (int)viewportSize, (float)viewportSize, (float)viewportSize);
                GlStateManager.func_179084_k();
                this.parent.func_73732_a(this.parent.field_146289_q, "N", width / 2 + 2, height / 2 - viewportSize / 2 + 2 - 10, 0xFFFFA0);
                this.parent.func_73732_a(this.parent.field_146289_q, "S", width / 2 + 2, height / 2 + viewportSize / 2 - 9 - 10, 0xFFFFA0);
                this.parent.func_73732_a(this.parent.field_146289_q, "E", width / 2 + viewportSize / 2 - 4, height / 2 - 3 - 10, 0xFFFFA0);
                this.parent.func_73732_a(this.parent.field_146289_q, "W", width / 2 - viewportSize / 2 + 5, height / 2 - 3 - 10, 0xFFFFA0);
            }
        }

        public void lerpAlpha(float partialTicks, float scale, float target) {
            this.mapAlpha = MathUtil.lerp(partialTicks * scale, this.mapAlpha, target);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ListPreset
    extends GuiSlot {
        private static final int LIST_PADDING_TOP = 32;
        private static final int LIST_PADDING_BOTTOM = 32;

        public ListPreset(GuiScreenCustomizePreview parent) {
            super(parent.field_146297_k, parent.field_146294_l, parent.field_146295_m, 32, parent.field_146295_m - 32, 1);
        }

        protected int func_148127_b() {
            return 1;
        }

        protected void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        }

        protected boolean func_148131_a(int slotIndex) {
            return false;
        }

        protected void func_148123_a() {
        }

        protected void func_192637_a(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        }
    }

    private static enum ProgressState {
        NOT_STARTED,
        STARTED,
        FAILED,
        SUCCEEDED,
        LOADED;

    }
}

