/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.compat;

import java.util.LinkedHashMap;
import java.util.Map;
import mod.bespectacled.modernbetaforge.ModernBeta;
import mod.bespectacled.modernbetaforge.compat.ClientCompat;
import mod.bespectacled.modernbetaforge.compat.biomesoplenty.CompatBiomesOPlenty;
import mod.bespectacled.modernbetaforge.compat.buildcraft.CompatBuildCraftEnergy;
import mod.bespectacled.modernbetaforge.compat.thaumcraft.CompatThaumcraft;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ClientModCompat {
    public static final Map<String, ClientCompat> LOADED_MODS = new LinkedHashMap<String, ClientCompat>();

    public static void loadCompat() {
        ClientModCompat.loadCompat(new CompatBiomesOPlenty());
        ClientModCompat.loadCompat(new CompatBuildCraftEnergy());
        ClientModCompat.loadCompat(new CompatThaumcraft());
    }

    public static boolean isModLoaded(String modId) {
        return LOADED_MODS.containsKey(modId);
    }

    private static void loadCompat(ClientCompat compat) {
        String modId = compat.getModId();
        if (Loader.isModLoaded((String)modId)) {
            try {
                ModernBeta.log(Level.INFO, String.format("Found client mod '%s'..", modId));
                compat.loadClient();
                LOADED_MODS.put(modId, compat);
            }
            catch (Exception e) {
                ModernBeta.log(Level.ERROR, String.format("Couldn't load client compat for mod '%s'!", modId));
            }
        }
    }
}

