/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.config;

import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizePresets;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="modernbetaforge")
public class ModernBetaConfig {
    public static CategoryGui guiOptions = new CategoryGui();
    public static CategoryGenerator generatorOptions = new CategoryGenerator();
    public static CategoryVisual visualOptions = new CategoryVisual();
    public static CategorySpawn spawnOptions = new CategorySpawn();
    public static CategoryServer serverOptions = new CategoryServer();
    public static CategoryDebug debugOptions = new CategoryDebug();

    @Mod.EventBusSubscriber(modid="modernbetaforge")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("modernbetaforge")) {
                ConfigManager.sync((String)"modernbetaforge", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class CategoryDebug {
        @Config.Comment(value={"Display Modern Beta debug info in debug screen."})
        public boolean displayDebugInfo = false;
        @Config.Comment(value={"Register debug properties at mod start-up."})
        @Config.RequiresMcRestart
        public boolean registerDebugProperties = false;
        @Config.Comment(value={"Debug block sources."})
        @Config.RequiresWorldRestart
        public boolean debugBlockSources = false;
        @Config.Comment(value={"Debug Indev level saving functionality."})
        @Config.RequiresWorldRestart
        public boolean debugIndevLevelSaves = false;
    }

    public static class CategoryServer {
        @Config.Comment(value={"Send world cloud height to joining clients"})
        @Config.RequiresWorldRestart
        public boolean sendCloudHeight = true;
    }

    public static class CategorySpawn {
        @Config.Comment(value={"Use spawn fuzz for players who join the world"})
        @Config.RequiresWorldRestart
        public boolean useSpawnFuzz = false;
    }

    public static class CategoryVisual {
        @Config.Comment(value={"Render Beta-accurate biome colors"})
        @Config.RequiresWorldRestart
        public boolean useBetaBiomeColors = true;
        @Config.Comment(value={"Render Beta-accurate sky colors"})
        @Config.RequiresWorldRestart
        public boolean useBetaSkyColors = true;
        @Config.Comment(value={"Render old sugar cane colors"})
        @Config.RequiresWorldRestart
        public boolean useOldSugarCaneColor = true;
        @Config.Comment(value={"Render fog with old fog color blending algorithm"})
        public boolean useOldFogColorBlending = true;
        @Config.Comment(value={"Modern Beta world cloud height"})
        @Config.RangeInt(min=0, max=255)
        public int cloudHeight = 108;
        @Config.Comment(value={"Override default cloud height."})
        public boolean useCustomCloudHeight = false;
        @Config.Comment(value={"Render biome colors with increasingly lower temperatures above y128"})
        @Config.RequiresWorldRestart
        public boolean useHeightTempGradient = true;
    }

    public static class CategoryGenerator {
        @Config.Comment(value={"Add biomes with custom surface builders for compatibility, requires fully-qualified biome registry name"})
        @Config.RequiresWorldRestart
        public String[] biomesWithCustomSurfaces = new String[0];
        @Config.Comment(value={"Save Indev level to separate file and try to load instead of regenerating level"})
        @Config.RequiresWorldRestart
        public boolean saveIndevLevels = true;
        @Config.Comment(value={"Max size of chunk cache. Higher values may improve performance at the cost of memory consumption, particularly in heavily-modded worlds. You probably don't need to change this!"})
        @Config.RequiresWorldRestart
        @Config.SlidingOption
        @Config.RangeInt(min=16, max=256)
        public int chunkCacheSize = 32;
    }

    public static class CategoryGui {
        @Config.Comment(value={"Default Modern Beta world preset"})
        @Config.RequiresWorldRestart
        public String defaultPreset = "";
        @Config.Comment(value={"Default Modern Beta world preset filter"})
        @Config.RequiresWorldRestart
        public GuiScreenCustomizePresets.FilterType defaultPresetFilter = GuiScreenCustomizePresets.FilterType.ALL;
        @Config.Comment(value={"Set Modern Beta world type as default"})
        @Config.RequiresWorldRestart
        public boolean useModernBetaAsDefault = false;
        @Config.Comment(value={"Use customization menus for selecting basic generator settings. Applies to chunk source, biome source, surface builder, and cave carver options."})
        @Config.RequiresWorldRestart
        public boolean useMenusForBasicSettings = true;
    }
}

