/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.util.mersenne;

public class MersenneTwister {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int DEFAULT_SEED = 4357;
    private static final int[] MAG_01 = new int[]{0, -1727483681};
    private final int[] mt = new int[624];
    private int mti = 625;

    public MersenneTwister() {
        this(4357);
    }

    public MersenneTwister(int seed) {
        this.init(seed);
    }

    public synchronized int genRandInt32() {
        int y;
        if (this.mti >= 624) {
            int kk;
            if (this.mti == 625) {
                this.init(4357);
            }
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ MAG_01[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ MAG_01[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ MAG_01[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    private synchronized void init(int seed) {
        this.mt[0] = seed & 0xFFFFFFFF;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFF;
        }
    }
}

