/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world;

import java.util.Random;
import mod.bespectacled.modernbetaforge.client.gui.GuiScreenCustomizeWorld;
import mod.bespectacled.modernbetaforge.config.ModernBetaConfig;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiomeProvider;
import mod.bespectacled.modernbetaforge.world.chunk.ModernBetaChunkGenerator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModernBetaWorldType
extends WorldType {
    public static final ModernBetaWorldType INSTANCE = new ModernBetaWorldType("modernbeta");
    private float cloudHeight = super.getCloudHeight();

    public ModernBetaWorldType(String name) {
        super(name);
    }

    public static void register() {
    }

    public boolean isCustomizable() {
        return true;
    }

    public float getCloudHeight() {
        if (ModernBetaConfig.visualOptions.useCustomCloudHeight) {
            return ModernBetaConfig.visualOptions.cloudHeight;
        }
        return this.cloudHeight;
    }

    public double getHorizon(World world) {
        return -512.0;
    }

    public boolean handleSlimeSpawnReduction(Random random, World world) {
        return world.func_181545_F() < 40 ? true : super.handleSlimeSpawnReduction(random, world);
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        return new ModernBetaChunkGenerator(world, generatorOptions);
    }

    public BiomeProvider getBiomeProvider(World world) {
        return new ModernBetaBiomeProvider(world.func_72912_H());
    }

    public int getSpawnFuzz(WorldServer world, MinecraftServer server) {
        return ModernBetaConfig.spawnOptions.useSpawnFuzz ? Math.max(0, server.func_184108_a(world)) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft minecraft, GuiCreateWorld guiCreateWorld) {
        minecraft.func_147108_a((GuiScreen)new GuiScreenCustomizeWorld((GuiScreen)guiCreateWorld, guiCreateWorld.field_146334_a));
    }

    public void setCloudHeight(int cloudHeight) {
        this.cloudHeight = cloudHeight;
    }
}

