/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.biomes.beta;

import java.util.Random;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBeta;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeBetaForest
extends BiomeBeta {
    private static final WorldGenBirchTree BIRCH_TREE_FEATURE = new WorldGenBirchTree(false, false);

    public BiomeBetaForest() {
        super(new Biome.BiomeProperties("Beta Forest").func_185410_a(0.7f).func_185395_b(0.8f).func_185398_c(0.1f).func_185400_d(0.4f));
        this.skyColor = 7777023;
        this.populateAdditionalMobs(null, true, WOLF_FOREST);
    }

    public void func_180624_a(World world, Random random, BlockPos startPos) {
        super.func_180624_a(world, random, startPos);
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        ChunkPos chunkPos = new ChunkPos(startPos);
        if (settings.useDoublePlants && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            this.addDoublePlants(world, random, startPos, random.nextInt(5) - 3);
        }
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(5) == 0) {
            return BIRCH_TREE_FEATURE;
        }
        if (random.nextInt(3) == 0) {
            return ModernBetaBiome.BIG_TREE_FEATURE;
        }
        return ModernBetaBiome.TREE_FEATURE;
    }

    @Override
    public WorldGenAbstractTree getRandomTreeFeature(Random random, ModernBetaGeneratorSettings settings) {
        if (!settings.useBirchTrees) {
            return super.func_150567_a(random);
        }
        return this.func_150567_a(random);
    }

    public void addDoublePlants(World world, Random random, BlockPos startPos, int flowerNdx) {
        block0: for (int i = 0; i < flowerNdx; ++i) {
            int flowerType = random.nextInt(3);
            if (flowerType == 0) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.SYRINGA);
            } else if (flowerType == 1) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.ROSE);
            } else if (flowerType == 2) {
                field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.PAEONIA);
            }
            for (int j = 0; j < 5; ++j) {
                int x = random.nextInt(16) + 8;
                int y = random.nextInt(16) + 8;
                int z = random.nextInt(world.func_175645_m(startPos.func_177982_a(x, 0, y)).func_177956_o() + 32);
                if (field_180280_ag.func_180709_b(world, random, new BlockPos(startPos.func_177958_n() + x, z, startPos.func_177952_p() + y))) continue block0;
            }
        }
    }
}

