/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.biomes.beta;

import java.util.Random;
import mod.bespectacled.modernbetaforge.world.biome.ModernBetaBiome;
import mod.bespectacled.modernbetaforge.world.biome.biomes.beta.BiomeBeta;
import mod.bespectacled.modernbetaforge.world.setting.ModernBetaGeneratorSettings;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenFossils;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeBetaSwampland
extends BiomeBeta {
    private static final WorldGenSwamp SWAMP_TREE_FEATURE = new WorldGenSwamp();

    public BiomeBetaSwampland() {
        super(new Biome.BiomeProperties("Beta Swampland").func_185410_a(0.5f).func_185395_b(1.0f).func_185398_c(0.1f).func_185400_d(0.2f));
        this.skyColor = 8430079;
        this.populateAdditionalMobs(EnumCreatureType.MONSTER, false, SLIME_SWAMP);
        this.field_76760_I.field_76806_I = 1;
        this.field_76760_I.field_76833_y = 4;
        this.field_76760_I.field_76805_H = 0;
        this.field_76760_I.field_76801_G = 0;
    }

    @Override
    public WorldGenAbstractTree getRandomTreeFeature(Random random, ModernBetaGeneratorSettings settings) {
        if (!settings.useSwampTrees) {
            return super.func_150567_a(random);
        }
        if (random.nextInt(5) == 0) {
            return ModernBetaBiome.TREE_FEATURE;
        }
        return SWAMP_TREE_FEATURE;
    }

    public BlockFlower.EnumFlowerType func_180623_a(Random random, BlockPos blockPos) {
        return BlockFlower.EnumFlowerType.BLUE_ORCHID;
    }

    public void func_180624_a(World world, Random random, BlockPos startPos) {
        BlockPos blockPos;
        int dY;
        int height;
        int dZ;
        int dX;
        int i;
        super.func_180624_a(world, random, startPos);
        ModernBetaGeneratorSettings settings = ModernBetaGeneratorSettings.buildOrGet(world);
        ChunkPos chunkPos = new ChunkPos(startPos);
        WorldGenWaterlily waterLilyGen = new WorldGenWaterlily();
        if (settings.useFossils && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FOSSIL) && random.nextInt(64) == 0) {
            new WorldGenFossils().func_180709_b(world, random, startPos);
        }
        if (settings.useLilyPads && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LILYPAD)) {
            for (i = 0; i < this.field_76760_I.field_76833_y; ++i) {
                BlockPos blockPosDown;
                dX = random.nextInt(16) + 8;
                height = world.func_175645_m(startPos.func_177982_a(dX, 0, dZ = random.nextInt(16) + 8)).func_177956_o() * 2;
                if (height <= 0) continue;
                dY = random.nextInt(height);
                blockPos = startPos.func_177982_a(dX, dY, dZ);
                while (blockPos.func_177956_o() > 0 && world.func_175623_d(blockPosDown = blockPos.func_177977_b())) {
                    blockPos = blockPosDown;
                }
                waterLilyGen.func_180709_b(world, random, blockPos);
            }
        }
        if (settings.useNewFlowers && TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            for (i = 0; i < 1; ++i) {
                BlockFlower.EnumFlowerType enumFlowerType;
                BlockFlower blockFlower;
                dX = random.nextInt(16) + 8;
                height = world.func_175645_m(startPos.func_177982_a(dX, 0, dZ = random.nextInt(16) + 8)).func_177956_o() + 32;
                if (height <= 0 || (blockFlower = (enumFlowerType = this.func_180623_a(random, blockPos = startPos.func_177982_a(dX, dY = random.nextInt(height), dZ))).func_176964_a().func_180346_a()).func_176223_P().func_185904_a() == Material.field_151579_a) continue;
                this.field_76760_I.field_150514_p.func_175914_a(blockFlower, enumFlowerType);
                this.field_76760_I.field_150514_p.func_180709_b(world, random, blockPos);
            }
        }
    }
}

