/*
 * Decompiled with CFR 0.152.
 */
package mod.bespectacled.modernbetaforge.world.biome.injector;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionResolver;
import mod.bespectacled.modernbetaforge.world.biome.injector.BiomeInjectionStep;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;

public class BiomeInjectionRules {
    private final Map<BiomeInjectionStep, List<BiomeInjectionRule>> ruleMap;

    private BiomeInjectionRules(Map<BiomeInjectionStep, List<BiomeInjectionRule>> ruleMap) {
        this.ruleMap = ruleMap;
    }

    public Biome test(BiomeInjectionContext context, int x, int z, BiomeInjectionStep step) {
        List<BiomeInjectionRule> rules = this.getRules(step);
        if (rules == null) {
            return null;
        }
        for (int i = 0; i < rules.size(); ++i) {
            Biome biome = rules.get(i).test(context).apply(x, z);
            if (biome == null) continue;
            return biome;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.ruleMap.isEmpty();
    }

    private List<BiomeInjectionRule> getRules(BiomeInjectionStep step) {
        return this.ruleMap.get((Object)step);
    }

    public static class BiomeInjectionContext {
        private BlockPos.MutableBlockPos pos;
        private IBlockState state;
        private IBlockState stateAbove;
        private Biome biome;

        public BiomeInjectionContext() {
            this(BlockPos.field_177992_a, null, null, null);
        }

        public BiomeInjectionContext(BlockPos pos, IBlockState state, IBlockState stateAbove, Biome biome) {
            this.pos = new BlockPos.MutableBlockPos(pos);
            this.state = state;
            this.stateAbove = stateAbove;
            this.biome = biome;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public IBlockState getState() {
            return this.state;
        }

        public IBlockState getStateAbove() {
            return this.stateAbove;
        }

        public Biome getBiome() {
            return this.biome;
        }

        public void setPos(int x, int y, int z) {
            this.pos.func_181079_c(x, y, z);
        }

        public void setState(IBlockState blockState) {
            this.state = blockState;
        }

        public void setStateAbove(IBlockState blockState) {
            this.stateAbove = blockState;
        }

        public void setBiome(Biome biome) {
            this.biome = biome;
        }
    }

    private static class BiomeInjectionRule {
        private final Predicate<BiomeInjectionContext> rule;
        private final BiomeInjectionResolver resolver;

        public BiomeInjectionRule(Predicate<BiomeInjectionContext> rule, BiomeInjectionResolver resolver) {
            this.rule = rule;
            this.resolver = resolver;
        }

        public BiomeInjectionResolver test(BiomeInjectionContext context) {
            if (this.rule.test(context)) {
                return this.resolver;
            }
            return BiomeInjectionResolver.DEFAULT;
        }
    }

    public static class Builder {
        private final Map<BiomeInjectionStep, List<BiomeInjectionRule>> ruleMap = new LinkedHashMap<BiomeInjectionStep, List<BiomeInjectionRule>>();

        public Builder() {
            this.ruleMap.put(BiomeInjectionStep.PRE_SURFACE, new ArrayList());
            this.ruleMap.put(BiomeInjectionStep.CUSTOM, new ArrayList());
            this.ruleMap.put(BiomeInjectionStep.POST_SURFACE, new ArrayList());
        }

        public Builder add(Predicate<BiomeInjectionContext> rule, BiomeInjectionResolver resolver, BiomeInjectionStep step) {
            this.ruleMap.get((Object)step).add(new BiomeInjectionRule(rule, resolver));
            return this;
        }

        public BiomeInjectionRules build() {
            return new BiomeInjectionRules(this.ruleMap);
        }
    }
}

