/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.block.model.ModelBlockDefinition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.dynamicresources.IExtendedModelLoader;
import org.embeddedt.vintagefix.dynamicresources.model.ModelLocationInformation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={ModelLoader.class})
@ClientOnlyMixin
public class MixinModelLoader
implements IExtendedModelLoader {
    private Cache<ResourceLocation, ModelBlockDefinition> modelBlockDefinitionCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).concurrencyLevel(8).softValues().build();

    @Overwrite
    public ModelBlockDefinition func_177586_a(ResourceLocation location) {
        ResourceLocation simpleLocation = new ResourceLocation(location.func_110624_b(), location.func_110623_a());
        try {
            return (ModelBlockDefinition)this.modelBlockDefinitionCache.get((Object)simpleLocation, () -> {
                try {
                    return ModelLocationInformation.loadModelBlockDefinition(simpleLocation);
                }
                catch (Exception e) {
                    VintageFix.LOGGER.debug("Error loading model block definition", e.getCause());
                    return new ModelBlockDefinition(new ArrayList());
                }
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    @Override
    public ModelBlockDefinition vfix$getModelBlockDef(ResourceLocation location) {
        return this.func_177586_a(location);
    }
}

