/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.stitcher;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.dynamicresources.TextureCollector;
import org.embeddedt.vintagefix.stitcher.HolderSlot;
import org.embeddedt.vintagefix.stitcher.Rect2D;
import org.embeddedt.vintagefix.stitcher.SpriteSlot;
import org.embeddedt.vintagefix.stitcher.StitcherState;
import org.embeddedt.vintagefix.stitcher.TooBigException;
import org.embeddedt.vintagefix.stitcher.packing2d.Algorithm;
import org.embeddedt.vintagefix.stitcher.packing2d.Packer;

public class TurboStitcher
extends SpriteSlot {
    private final int maxWidth;
    private final int maxHeight;
    private final boolean forcePowerOf2;
    private List<SpriteSlot> slots = new LinkedList<SpriteSlot>();
    private List<SpriteSlot> finalizedSlots = null;
    private boolean needsSorting = false;
    private int trackedArea = 0;
    private StitcherState state = StitcherState.SETUP;
    private static final boolean OPTIMAL_PACKING = true;

    public TurboStitcher(int maxWidth, int maxHeight, boolean forcePowerOf2) {
        this.maxHeight = maxHeight;
        this.maxWidth = maxWidth;
        this.forcePowerOf2 = forcePowerOf2;
    }

    private static int nextPowerOfTwo(int number) {
        --number;
        number |= number >>> 1;
        number |= number >>> 2;
        number |= number >>> 4;
        number |= number >>> 8;
        number |= number >>> 16;
        return ++number;
    }

    public void addSprite(Stitcher.Holder holder) {
        this.addSprite(new HolderSlot(holder));
    }

    public void addSprite(SpriteSlot rect) {
        this.verifyState(StitcherState.SETUP);
        this.slots.add(rect);
        this.trackedArea += rect.width * rect.height;
        this.needsSorting = true;
    }

    public void reset() {
        this.state = StitcherState.SETUP;
    }

    public void dropFirst() {
        this.verifyState(StitcherState.SETUP);
        if (this.slots.size() > 0) {
            SpriteSlot slot = this.slots.remove(0);
            String name = slot instanceof HolderSlot ? ((HolderSlot)slot).getHolder().func_98150_a().func_94215_i() : "unknown";
            VintageFix.LOGGER.warn("Dropping {}x{} texture '{}' from atlas as it's too large", (Object)slot.width, (Object)slot.height, (Object)name);
            this.trackedArea -= slot.width * slot.height;
        } else {
            throw new IllegalStateException();
        }
    }

    public void retainAllSprites(Set<ResourceLocation> theLocations) {
        this.verifyState(StitcherState.SETUP);
        HashSet<String> locationStrings = new HashSet<String>();
        for (ResourceLocation rl : theLocations) {
            locationStrings.add(rl.toString());
        }
        this.slots.removeIf(slot -> {
            String spriteName;
            if (slot instanceof HolderSlot && TextureCollector.weaklyCollectedTextures.contains(spriteName = ((HolderSlot)slot).getHolder().func_98150_a().func_94215_i()) && !locationStrings.contains(spriteName)) {
                VintageFix.LOGGER.warn("Dropping unreferenced sprite " + ((HolderSlot)slot).getHolder().func_98150_a().func_94215_i());
                this.trackedArea -= slot.width * slot.height;
                return true;
            }
            return false;
        });
    }

    public void stitch() throws TooBigException {
        List<SpriteSlot> packedSlots;
        this.verifyState(StitcherState.SETUP);
        this.width = 0;
        this.height = 0;
        if (this.slots.size() == 0) {
            this.state = StitcherState.STITCHED;
            return;
        }
        if (this.needsSorting) {
            Collections.sort(this.slots);
            this.needsSorting = false;
        }
        if (this.trackedArea > this.maxWidth * this.maxHeight) {
            throw new TooBigException();
        }
        for (SpriteSlot slot : this.slots) {
            this.width = Math.max(this.width, slot.width);
        }
        if (this.forcePowerOf2) {
            this.width = TurboStitcher.nextPowerOfTwo(this.width);
        }
        if (this.width > this.maxWidth) {
            throw new TooBigException();
        }
        this.width = Math.max(this.width >>> 1, 1);
        ArrayList<SpriteSlot> toPack = new ArrayList<SpriteSlot>(this.slots);
        do {
            if (this.width == this.maxWidth) {
                throw new TooBigException();
            }
            this.width = this.forcePowerOf2 ? (this.width *= 2) : (this.width += Math.min(this.width, 16));
            if (this.width > this.maxWidth) {
                this.width = this.maxWidth;
            }
            packedSlots = Packer.pack(toPack, Algorithm.FIRST_FIT_DECREASING_HEIGHT, this.width);
            this.height = 0;
            for (SpriteSlot sprite : packedSlots) {
                this.height = Math.max(this.height, sprite.y + sprite.height);
            }
            if (!this.forcePowerOf2) continue;
            this.height = TurboStitcher.nextPowerOfTwo(this.height);
        } while (this.height > this.maxHeight || this.height > this.width);
        this.finalizedSlots = packedSlots;
        this.state = StitcherState.STITCHED;
        TextureCollector.weaklyCollectedTextures = ImmutableSet.of();
    }

    public List<Stitcher.Slot> getSlots() {
        return this.getSlots(new Rect2D());
    }

    @Override
    public List<Stitcher.Slot> getSlots(Rect2D parent) {
        this.verifyState(StitcherState.STITCHED);
        ArrayList<Stitcher.Slot> mineSlots = new ArrayList<Stitcher.Slot>();
        Rect2D offset = new Rect2D(this.x + parent.x, this.y + parent.y, this.width, this.height);
        for (SpriteSlot slot : this.finalizedSlots) {
            mineSlots.addAll(slot.getSlots(offset));
        }
        return mineSlots;
    }

    private void verifyState(StitcherState ... allowedStates) {
        boolean ok = false;
        for (StitcherState state : allowedStates) {
            if (state != this.state) continue;
            ok = true;
            break;
        }
        if (!ok) {
            throw new IllegalStateException("Cold not execute operation: invalid state");
        }
    }
}

