/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.session;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.session.SessionChecker;
import technicianlp.reauth.util.ReflectionUtils;

public final class SessionHelper {
    private static final Field sessionField = ReflectionUtils.findObfuscatedField(Minecraft.class, "field_71449_j", "session");
    private static final Pattern usernamePattern = Pattern.compile("[A-Za-z0-9_]{2,16}");

    public static void setOfflineUsername(String username) {
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
        SessionHelper.setSession(new SessionData(username, uuid.toString(), "invalid", "legacy"));
    }

    public static void setSession(SessionData data) {
        try {
            Minecraft minecraft = Minecraft.func_71410_x();
            Session session = new Session(data.username, data.uuid, data.accessToken, data.type);
            ReflectionUtils.setField(sessionField, minecraft, session);
            SessionChecker.invalidate();
            minecraft.func_181037_M().clear();
            minecraft.func_181037_M();
        }
        catch (Exception e) {
            ReAuth.log.error("Failed to update Session", (Throwable)e);
        }
    }

    public static boolean isValidOfflineUsername(String username) {
        return usernamePattern.matcher(username).matches();
    }
}

