/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.block;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.block.MoCBlockDirt;
import drzhark.mocreatures.block.MoCBlockGrass;
import drzhark.mocreatures.dimension.worldgen.MoCWorldGenBigTree;
import drzhark.mocreatures.init.MoCBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.TerrainGen;

public class MoCBlockSapling
extends BlockBush
implements IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    public boolean flammable;
    private EnumWoodType woodType;

    public MoCBlockSapling(EnumWoodType woodType, MapColor mapColor, boolean flammable) {
        super(Material.field_151585_k, mapColor);
        this.flammable = flammable;
        this.func_149647_a(MoCreatures.tabMoC);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.woodType = woodType;
    }

    public MoCBlockSapling(Material material, MapColor mapColor) {
        super(material, mapColor);
    }

    public boolean isFlammable() {
        return this.flammable;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable()) {
            return Blocks.field_150345_g.getFlammability(world, pos, face);
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable()) {
            return Blocks.field_150345_g.getFireSpreadSpeed(world, pos, face);
        }
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (!world.func_175697_a(pos, 1)) {
                return;
            }
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(world, pos, state, rand);
            }
        }
    }

    public void grow(World world, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(world, pos, state, rand);
        }
    }

    public void generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        MoCWorldGenBigTree generator = null;
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch (this.woodType) {
            case WYVWOOD: {
                block3: for (i = 0; i >= -1; --i) {
                    for (j = 0; j >= -1; --j) {
                        if (!this.isTwoByTwoOfType(world, pos, i, j, EnumWoodType.WYVWOOD)) continue;
                        generator = new MoCWorldGenBigTree(false, MoCBlocks.wyvwoodLog.func_176223_P(), MoCBlocks.wyvwoodLeaves.func_176203_a(0), 2, 30, 10);
                        flag = true;
                        break block3;
                    }
                }
                if (flag) break;
                return;
            }
        }
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            world.func_180501_a(pos.func_177982_a(i, 0, j), air, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j), air, 4);
            world.func_180501_a(pos.func_177982_a(i, 0, j + 1), air, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), air, 4);
        } else {
            world.func_180501_a(pos, air, 4);
        }
        if (!generator.func_180709_b(world, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                world.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                world.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                world.func_180501_a(pos, state, 4);
            }
        }
    }

    private boolean isTwoByTwoOfType(World world, BlockPos pos, int xOffset, int zOffset, EnumWoodType type) {
        return this.isTypeAt(world, pos.func_177982_a(xOffset, 0, zOffset), type) && this.isTypeAt(world, pos.func_177982_a(xOffset + 1, 0, zOffset), type) && this.isTypeAt(world, pos.func_177982_a(xOffset, 0, zOffset + 1), type) && this.isTypeAt(world, pos.func_177982_a(xOffset + 1, 0, zOffset + 1), type);
    }

    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    public boolean isTypeAt(World world, BlockPos pos, EnumWoodType type) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof MoCBlockSapling) {
            return ((MoCBlockSapling)state.func_177230_c()).getWoodType() == type;
        }
        return false;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.grow(world, pos, state, rand);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        Block soil = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return soil instanceof MoCBlockGrass || soil instanceof MoCBlockDirt || soil instanceof BlockGrass || soil instanceof BlockDirt || soil instanceof BlockFarmland;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        Block tempblock = soil.func_177230_c();
        if (tempblock instanceof MoCBlockDirt || tempblock instanceof MoCBlockGrass) {
            return true;
        }
        return super.func_176196_c(world, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public static enum EnumWoodType implements IStringSerializable
    {
        WYVWOOD(0, "wyvwood");

        private final String name;
        private final int meta;

        private EnumWoodType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumWoodType byMeta(int meta) {
            for (EnumWoodType woodType : EnumWoodType.values()) {
                if (woodType.meta != meta) continue;
                return woodType;
            }
            return WYVWOOD;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

