/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.compat.datafixes;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockIDFixer
implements IFixableData {
    private static final Map<ResourceLocation, ResourceLocation> BLOCK_NAME_MAPPINGS = new HashMap<ResourceLocation, ResourceLocation>();

    public BlockIDFixer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int func_188216_a() {
        return 1;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        return compound;
    }

    @SubscribeEvent
    public void missingBlockMapping(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            Block newBlock;
            ResourceLocation oldName = entry.key;
            ResourceLocation newName = BLOCK_NAME_MAPPINGS.get(oldName);
            if (newName == null || (newBlock = (Block)ForgeRegistries.BLOCKS.getValue(newName)) == null) continue;
            entry.remap((IForgeRegistryEntry)newBlock);
        }
    }

    @SubscribeEvent
    public void missingItemBlockMapping(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            Item newItem;
            ResourceLocation oldName = entry.key;
            ResourceLocation newName = BLOCK_NAME_MAPPINGS.get(oldName);
            if (newName == null || (newItem = (Item)ForgeRegistries.ITEMS.getValue(newName)) == null) continue;
            entry.remap((IForgeRegistryEntry)newItem);
        }
    }

    static {
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCStone"), new ResourceLocation("mocreatures", "wyvstone"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCGrass"), new ResourceLocation("mocreatures", "wyvgrass"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCDirt"), new ResourceLocation("mocreatures", "wyvdirt"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCLeaves"), new ResourceLocation("mocreatures", "wyvwood_leaves"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCLog"), new ResourceLocation("mocreatures", "wyvwood_log"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCTallGrass"), new ResourceLocation("mocreatures", "tall_wyvgrass"));
        BLOCK_NAME_MAPPINGS.put(new ResourceLocation("mocreatures", "MoCWoodPlank"), new ResourceLocation("mocreatures", "wyvwood_planks"));
    }
}

