/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.compat.tinkers.traits.armor;

import c4.conarm.lib.armor.ArmorModifications;
import c4.conarm.lib.traits.AbstractArmorTrait;
import com.google.common.collect.ImmutableList;
import drzhark.mocreatures.entity.MoCEntityAquatic;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitThresherArmor
extends AbstractArmorTrait {
    private static final float MODIFIER = 0.4f;

    public TraitThresherArmor() {
        super("mocreatures.thresher", 12039833);
    }

    private double calcAttack(ItemStack armor) {
        int durability = ToolHelper.getCurrentDurability((ItemStack)armor);
        int maxDurability = ToolHelper.getMaxDurability((ItemStack)armor);
        return Math.log((double)(maxDurability - durability) / 72.0 + 1.0) * 2.0;
    }

    public float onHurt(ItemStack armor, EntityPlayer player, DamageSource source, float damage, float newDamage, LivingHurtEvent event) {
        if (source.func_76364_f() instanceof EntityLivingBase) {
            TraitThresherArmor.attackEntitySecondary((DamageSource)new EntityDamageSource("thresher", (Entity)player).func_180138_v(), (float)((float)this.calcAttack(armor)), (Entity)source.func_76364_f(), (boolean)true, (boolean)false, (boolean)false);
        }
        return newDamage;
    }

    public ArmorModifications getModifications(EntityPlayer player, ArmorModifications mods, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76364_f() instanceof EntityWaterMob || source.func_76364_f() instanceof MoCEntityAquatic) {
            return super.getModifications(player, mods, armor, source, damage, slot);
        }
        mods.addEffectiveness(0.4f);
        return super.getModifications(player, mods, armor, source, damage, slot);
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String damage = String.format("modifier.%s.extra.damage", this.getModifierIdentifier());
        String protection = String.format("modifier.%s.extra.protection", this.getModifierIdentifier());
        return ImmutableList.of((Object)Util.translateFormatted((String)damage, (Object[])new Object[]{Util.df.format(this.calcAttack(tool))}), (Object)Util.translateFormatted((String)protection, (Object[])new Object[]{Util.dfPercent.format(0.4f)}));
    }
}

