/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.IMoCEntity;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MoCEntityAmbient
extends EntityCreature
implements IMoCEntity {
    protected static final DataParameter<Boolean> ADULT = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> NAME_STR = EntityDataManager.func_187226_a(MoCEntityAmbient.class, (DataSerializer)DataSerializers.field_187194_d);
    protected String texture;
    protected boolean riderIsDisconnecting;

    protected MoCEntityAmbient(World world) {
        super(world);
    }

    @SideOnly(value=Side.CLIENT)
    public String func_70005_c_() {
        String entityString = EntityList.func_75621_b((Entity)this);
        if (!MoCreatures.proxy.verboseEntityNames || entityString == null) {
            return super.func_70005_c_();
        }
        String translationKey = "entity." + entityString + ".verbose.name";
        String translatedString = I18n.func_135052_a((String)translationKey, (Object[])new Object[0]);
        return !translatedString.equals(translationKey) ? translatedString : super.func_70005_c_();
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture(this.texture);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData par1EntityLivingData) {
        this.selectType();
        return super.func_180482_a(difficulty, par1EntityLivingData);
    }

    @Override
    public void selectType() {
        this.setType(1);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ADULT, (Object)false);
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
        this.field_70180_af.func_187214_a(AGE, (Object)45);
        this.field_70180_af.func_187214_a(NAME_STR, (Object)"");
    }

    @Override
    public int getType() {
        return (Integer)this.field_70180_af.func_187225_a(TYPE);
    }

    @Override
    public void setType(int i) {
        this.field_70180_af.func_187227_b(TYPE, (Object)i);
    }

    @Override
    public boolean renderName() {
        return MoCreatures.proxy.getDisplayPetName() && this.getPetName() != null && !this.getPetName().isEmpty() && !this.func_184207_aI() && this.func_184187_bx() == null;
    }

    @Override
    public boolean shouldRenderNameAndHealth() {
        return this.getIsTamed() && !this.func_184207_aI() && this.func_184187_bx() == null;
    }

    @Override
    public boolean getIsAdult() {
        return (Boolean)this.field_70180_af.func_187225_a(ADULT);
    }

    @Override
    public void setAdult(boolean flag) {
        this.field_70180_af.func_187227_b(ADULT, (Object)flag);
    }

    @Override
    public String getPetName() {
        return (String)this.field_70180_af.func_187225_a(NAME_STR);
    }

    @Override
    public void setPetName(String name) {
        this.field_70180_af.func_187227_b(NAME_STR, (Object)name);
    }

    @Override
    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    @Override
    public void setAge(int i) {
        this.field_70180_af.func_187227_b(AGE, (Object)i);
    }

    @Override
    public boolean getIsTamed() {
        return false;
    }

    @Override
    public int getOwnerPetId() {
        return 0;
    }

    @Override
    public void setOwnerPetId(int petId) {
    }

    @Override
    public UUID getOwnerId() {
        return null;
    }

    @Override
    public boolean checkSpawningBiome() {
        return true;
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isMovementCeased()) {
                this.func_70661_as().func_75499_g();
            }
            this.func_70661_as().func_75501_e();
        }
        super.func_70636_d();
    }

    public boolean swimmerEntity() {
        return false;
    }

    public void dropMyStuff() {
    }

    protected boolean isMyHealFood(ItemStack itemstack) {
        return false;
    }

    public boolean func_70090_H() {
        if (this.swimmerEntity()) {
            return false;
        }
        return super.func_70090_H();
    }

    public boolean func_70648_aU() {
        return this.swimmerEntity();
    }

    public void faceLocation(int i, int j, int k, float f) {
        double var4 = (double)i + 0.5 - this.field_70165_t;
        double var8 = (double)k + 0.5 - this.field_70161_v;
        double var6 = (double)j + 0.5 - this.field_70163_u;
        double var14 = MathHelper.func_76133_a((double)(var4 * var4 + var8 * var8));
        float var12 = (float)(Math.atan2(var8, var4) * 180.0 / Math.PI) - 90.0f;
        float var13 = (float)(-(Math.atan2(var6, var14) * 180.0 / Math.PI));
        this.field_70125_A = -this.updateRotation(this.field_70125_A, var13, f);
        this.field_70177_z = this.updateRotation(this.field_70177_z, var12, f);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float var4;
        for (var4 = par2 - par1; var4 < -180.0f; var4 += 360.0f) {
        }
        while (var4 >= 180.0f) {
            var4 -= 360.0f;
        }
        if (var4 > par3) {
            var4 = par3;
        }
        if (var4 < -par3) {
            var4 = -par3;
        }
        return par1 + var4;
    }

    public void getMyOwnPath(Entity entity, float f) {
        Path pathentity = this.func_70661_as().func_75494_a(entity);
        if (pathentity != null) {
            this.func_70661_as().func_75484_a(pathentity, 1.0);
        }
    }

    public boolean func_70601_bi() {
        boolean willSpawn;
        boolean debug = MoCreatures.proxy.debug;
        boolean bl = willSpawn = this.field_70170_p.func_175678_i(new BlockPos((Entity)this)) && this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        if (willSpawn && debug) {
            MoCreatures.LOGGER.info("Ambient: " + this.func_70005_c_() + " at: " + this.func_180425_c() + " State: " + this.field_70170_p.func_180495_p(this.func_180425_c()) + " biome: " + MoCTools.biomeName(this.field_70170_p, this.func_180425_c()));
        }
        return willSpawn;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound = MoCTools.getEntityData((Entity)this);
        nbttagcompound.func_74757_a("Adult", this.getIsAdult());
        nbttagcompound.func_74768_a("Edad", this.getAge());
        nbttagcompound.func_74778_a("Name", this.getPetName());
        nbttagcompound.func_74768_a("TypeInt", this.getType());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        nbttagcompound = MoCTools.getEntityData((Entity)this);
        this.setAdult(nbttagcompound.func_74767_n("Adult"));
        this.setAge(nbttagcompound.func_74762_e("Edad"));
        this.setPetName(nbttagcompound.func_74779_i("Name"));
        this.setType(nbttagcompound.func_74762_e("TypeInt"));
    }

    @Override
    public void makeEntityJump() {
    }

    @Override
    public boolean isFlyer() {
        return false;
    }

    @Override
    public void makeEntityDive() {
    }

    @Override
    public int nameYOffset() {
        return -80;
    }

    @Override
    public void performAnimation(int attackType) {
    }

    public boolean isMyFavoriteFood(ItemStack par1ItemStack) {
        return false;
    }

    public boolean isOnAir() {
        return this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 0.2)), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.2)), MathHelper.func_76128_c((double)this.field_70161_v)));
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    @Override
    public float getAdjustedYOffset() {
        return 0.0f;
    }

    public boolean getIsRideable() {
        return false;
    }

    public void setRideable(boolean b) {
    }

    @Override
    public void setArmorType(int i) {
    }

    protected EntityLivingBase getBoogey(double d) {
        EntityLivingBase entityliving = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(d, 4.0, d));
        for (Entity entity : list) {
            if (!this.entitiesToInclude(entity)) continue;
            entityliving = (EntityLivingBase)entity;
        }
        return entityliving;
    }

    public boolean entitiesToInclude(Entity entity) {
        return entity instanceof EntityLivingBase && ((double)entity.field_70130_N >= 0.5 || (double)entity.field_70131_O >= 0.5);
    }

    @Override
    public float pitchRotationOffset() {
        return 0.0f;
    }

    @Override
    public float rollRotationOffset() {
        return 0.0f;
    }

    @Override
    public float yawRotationOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedZOffset() {
        return 0.0f;
    }

    @Override
    public float getAdjustedXOffset() {
        return 0.0f;
    }

    protected boolean canBeTrappedInNet() {
        return this instanceof IMoCTameable && this.getIsTamed();
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.AMBIENT;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && !MoCTools.isThisPlayerAnOP(player) && this.getIsTamed() && !player.func_110124_au().equals(this.getOwnerId())) {
            return false;
        }
        return super.func_184652_a(player);
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean isNotScared() {
        return false;
    }

    @Override
    public boolean isMovementCeased() {
        return this.getIsSitting();
    }

    @Override
    public boolean shouldAttackPlayers() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    public double getDivingDepth() {
        return 0.5;
    }

    @Override
    public boolean isDiving() {
        return false;
    }

    @Override
    public void forceEntityJump() {
        this.func_70664_aZ();
    }

    public void func_180430_e(float f, float f1) {
    }

    @Override
    public int minFlyingHeight() {
        return 2;
    }

    @Override
    public int maxFlyingHeight() {
        return 4;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (!this.getIsFlying()) {
            super.func_191986_a(strafe, vertical, forward);
            return;
        }
        this.moveEntityWithHeadingFlying(strafe, vertical, forward);
    }

    public void moveEntityWithHeadingFlying(float strafe, float vertical, float forward) {
        if (this.func_70613_aW()) {
            this.func_191958_b(strafe, vertical, forward, 0.1f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.9f;
            this.field_70181_x *= (double)0.9f;
            this.field_70179_y *= (double)0.9f;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public boolean getIsFlying() {
        return false;
    }

    @Override
    public String getClazzString() {
        return EntityList.func_75621_b((Entity)this);
    }

    @Override
    public boolean getIsGhost() {
        return false;
    }

    public void func_110162_b(Entity entityIn, boolean sendAttachNotification) {
        if (this.getIsTamed() && entityIn instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityIn;
            if (MoCreatures.proxy.enableOwnership && this.getOwnerId() != null && !entityplayer.func_110124_au().equals(this.getOwnerId()) && !MoCTools.isThisPlayerAnOP(entityplayer)) {
                return;
            }
        }
        super.func_110162_b(entityIn, sendAttachNotification);
    }

    @Override
    public boolean canRidePlayer() {
        return false;
    }

    @Override
    public boolean startRidingPlayer(EntityPlayer player) {
        if (MoCTools.getEntityRidingPlayer(player) != null) {
            return false;
        }
        boolean ret = super.func_184220_m((Entity)player);
        if (ret) {
            NBTTagCompound tag = player.getEntityData();
            tag.func_186854_a("MOCEntity_Riding_Player", this.func_110124_au());
            return true;
        }
        return false;
    }

    @Override
    public void onStopRidingPlayer() {
    }
}

