/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.item.MoCEntityThrowableRock;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MoCEntityMiniGolem
extends MoCEntityMob {
    private static final DataParameter<Boolean> ANGRY = EntityDataManager.func_187226_a(MoCEntityMiniGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_ROCK = EntityDataManager.func_187226_a(MoCEntityMiniGolem.class, (DataSerializer)DataSerializers.field_187198_h);
    public int tCounter;
    public MoCEntityThrowableRock tempRock;

    public MoCEntityMiniGolem(World world) {
        super(world);
        this.texture = "mini_golem.png";
        this.func_70105_a(0.9f, 1.2f);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIGolemAttack(this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIGolemTarget<EntityPlayer>(this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, new AIGolemTarget<EntityIronGolem>(this, EntityIronGolem.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(HAS_ROCK, (Object)Boolean.FALSE);
    }

    public boolean getIsAngry() {
        return (Boolean)this.field_70180_af.func_187225_a(ANGRY);
    }

    public void setIsAngry(boolean flag) {
        this.field_70180_af.func_187227_b(ANGRY, (Object)flag);
    }

    public boolean getHasRock() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_ROCK);
    }

    public void setHasRock(boolean flag) {
        this.field_70180_af.func_187227_b(HAS_ROCK, (Object)flag);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            this.setIsAngry(this.func_70638_az() != null);
            if (this.getIsAngry() && this.func_70638_az() != null && !this.getHasRock() && this.field_70146_Z.nextInt(30) == 0) {
                this.acquireTRock();
            }
            if (this.getHasRock()) {
                this.func_70661_as().func_75499_g();
                this.attackWithTRock();
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (this.getHasRock() && this.tempRock != null) {
            this.tempRock.transformToItem();
        }
        super.func_70645_a(cause);
    }

    protected void acquireTRock() {
        IBlockState tRockState = MoCTools.destroyRandomBlockWithIBlockState((Entity)this, 3.0);
        if (tRockState == null) {
            this.tCounter = 1;
            this.setHasRock(false);
            return;
        }
        MoCEntityThrowableRock tRock = new MoCEntityThrowableRock(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v);
        this.field_70170_p.func_72838_d((Entity)tRock);
        tRock.setState(tRockState);
        tRock.setBehavior(1);
        this.tempRock = tRock;
        this.setHasRock(true);
    }

    protected void attackWithTRock() {
        ++this.tCounter;
        if (this.tCounter < 50) {
            this.tempRock.field_70165_t = this.field_70165_t;
            this.tempRock.field_70163_u = this.field_70163_u + 1.0;
            this.tempRock.field_70161_v = this.field_70161_v;
        }
        if (this.tCounter >= 50) {
            if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 48.0f) {
                MoCTools.throwStone((Entity)this, (Entity)this.func_70638_az(), this.tempRock.getState(), 10.0, 0.25);
            } else {
                this.tempRock.transformToItem();
            }
            this.tempRock.func_70106_y();
            this.setHasRock(false);
            this.tCounter = 0;
        }
    }

    @Override
    public float getSizeFactor() {
        return 1.0f;
    }

    protected void func_180429_a(BlockPos p_180429_1_, Block p_180429_2_) {
        if (MoCreatures.proxy.legacyMiniGolemSounds) {
            this.func_184185_a(MoCSoundEvents.ENTITY_GENERIC_STOMP, 1.0f, 1.0f);
        } else {
            this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
        }
    }

    protected SoundEvent func_184615_bR() {
        return MoCreatures.proxy.legacyMiniGolemSounds ? MoCSoundEvents.ENTITY_BIG_GOLEM_HURT_LEGACY : MoCSoundEvents.ENTITY_MINI_GOLEM_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCreatures.proxy.legacyMiniGolemSounds ? MoCSoundEvents.ENTITY_BIG_GOLEM_HURT_LEGACY : MoCSoundEvents.ENTITY_MINI_GOLEM_HURT;
    }

    protected SoundEvent func_184639_G() {
        return MoCreatures.proxy.legacyMiniGolemSounds ? MoCSoundEvents.ENTITY_BIG_GOLEM_AMBIENT : null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return MoCLootTables.MINI_GOLEM;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.92f;
    }

    static class AIGolemTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIGolemTarget(MoCEntityMiniGolem golem, Class<T> classTarget, boolean checkSight) {
            super((EntityCreature)golem, classTarget, checkSight);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    static class AIGolemAttack
    extends EntityAIAttackMelee {
        public AIGolemAttack(MoCEntityMiniGolem golem, double speed, boolean useLongMemory) {
            super((EntityCreature)golem, speed, useLongMemory);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }
    }
}

