/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.init.MoCLootTables;
import drzhark.mocreatures.init.MoCSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityRat
extends MoCEntityMob {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(MoCEntityRat.class, (DataSerializer)DataSerializers.field_187198_h);

    public MoCEntityRat(World world) {
        super(world);
        this.func_70105_a(0.58f, 0.455f);
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIRatAttack(this, 1.0, true));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIRatTarget<EntityPlayer>(this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, new AIRatTarget<EntityIronGolem>(this, EntityIronGolem.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)Boolean.FALSE);
    }

    @Override
    public void selectType() {
        this.checkSpawningBiome();
        if (this.getType() == 0) {
            int i = this.field_70146_Z.nextInt(100);
            if (i <= 65) {
                this.setType(1);
            } else if (i <= 98) {
                this.setType(2);
            } else {
                this.setType(3);
            }
        }
    }

    @Override
    public ResourceLocation getTexture() {
        switch (this.getType()) {
            case 2: {
                return MoCreatures.proxy.getModelTexture("rat_black.png");
            }
            case 3: {
                return MoCreatures.proxy.getModelTexture("rat_white.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("rat_brown.png");
    }

    @Override
    public boolean checkSpawningBiome() {
        BlockPos pos = new BlockPos((double)MathHelper.func_76128_c((double)this.field_70165_t), (double)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), this.field_70161_v);
        Biome currentbiome = MoCTools.biomeKind(this.field_70170_p, pos);
        try {
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.MESA)) {
                this.setType(1);
            }
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                this.setType(3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return null;
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        Entity entity = damagesource.func_76346_g();
        if (entity instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)entity);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72872_a(MoCEntityRat.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(16.0, 4.0, 16.0));
                for (MoCEntityRat entityrat : list) {
                    if (entityrat == null || entityrat.func_70638_az() != null) continue;
                    entityrat.func_70624_b((EntityLivingBase)entity);
                }
            }
        }
        return super.func_70097_a(damagesource, i);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70146_Z.nextInt(100) == 0 && this.func_70013_c() > 0.5f) {
            this.func_70624_b(null);
        }
    }

    protected SoundEvent func_184615_bR() {
        return MoCreatures.proxy.legacyRatDeathSound ? MoCSoundEvents.ENTITY_RAT_DEATH_LEGACY : MoCSoundEvents.ENTITY_RAT_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_RAT_HURT;
    }

    protected SoundEvent func_184639_G() {
        return MoCSoundEvents.ENTITY_RAT_AMBIENT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return MoCLootTables.RAT;
    }

    @Override
    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    static class AIRatTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIRatTarget(MoCEntityRat rat, Class<T> classTarget, boolean checkSight) {
            super((EntityCreature)rat, classTarget, checkSight);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    static class AIRatAttack
    extends EntityAIAttackMelee {
        public AIRatAttack(MoCEntityRat rat, double speed, boolean useLongMemory) {
            super((EntityCreature)rat, speed, useLongMemory);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

