/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hostile;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.MoCEntityMob;
import drzhark.mocreatures.entity.hostile.MoCEntityCaveScorpion;
import drzhark.mocreatures.entity.hostile.MoCEntityDirtScorpion;
import drzhark.mocreatures.entity.hostile.MoCEntityFireScorpion;
import drzhark.mocreatures.entity.hostile.MoCEntityFrostScorpion;
import drzhark.mocreatures.entity.hostile.MoCEntityUndeadScorpion;
import drzhark.mocreatures.entity.hunter.MoCEntityPetScorpion;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCSoundEvents;
import drzhark.mocreatures.network.MoCMessageHandler;
import drzhark.mocreatures.network.message.MoCMessageAnimation;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MoCEntityScorpion
extends MoCEntityMob {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(MoCEntityScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_BABIES = EntityDataManager.func_187226_a(MoCEntityScorpion.class, (DataSerializer)DataSerializers.field_187198_h);
    public int mouthCounter;
    public int armCounter;
    public int getType;
    private boolean isPoisoning;
    private int poisontimer;

    public MoCEntityScorpion(World world, int type) {
        super(world);
        this.func_70105_a(1.4f, 0.9f);
        this.setAdult(true);
        this.setAge(20);
        this.poisontimer = 0;
        this.getType = type;
        if (!this.field_70170_p.field_72995_K) {
            this.setHasBabies(this.getIsAdult() && this.field_70146_Z.nextInt(4) == 0);
        }
        this.field_70728_aV = 5;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIScorpionAttack(this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, new AIScorpionTarget<EntityPlayer>(this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, new AIScorpionTarget<EntityIronGolem>(this, EntityIronGolem.class, true));
    }

    @Override
    public ResourceLocation getTexture() {
        return MoCreatures.proxy.getModelTexture("scorpion_dirt.png");
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(HAS_BABIES, (Object)Boolean.FALSE);
    }

    public boolean getHasBabies() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BABIES);
    }

    public void setHasBabies(boolean flag) {
        this.field_70180_af.func_187227_b(HAS_BABIES, (Object)flag);
    }

    public boolean getIsPoisoning() {
        return this.isPoisoning;
    }

    public void setPoisoning(boolean flag) {
        if (flag && !this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 0), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        this.isPoisoning = flag;
    }

    @Override
    public void performAnimation(int animationType) {
        if (animationType == 0) {
            this.setPoisoning(true);
        } else if (animationType == 1) {
            this.armCounter = 1;
            this.swingArm();
        } else if (animationType == 3) {
            this.mouthCounter = 1;
        }
    }

    @Override
    public boolean func_70617_f_() {
        return this.isBesideClimbableBlock();
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.poisontimer != 1) {
            MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_ATTACK);
        }
        return super.func_70652_k(entity);
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.func_184187_bx() != null) {
            this.field_70177_z = this.func_184187_bx().field_70177_z;
        }
        if (this.mouthCounter != 0 && this.mouthCounter++ > 50) {
            this.mouthCounter = 0;
        }
        if (this.armCounter != 0 && this.armCounter++ > 24) {
            this.armCounter = 0;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_184207_aI() && this.getIsAdult() && !this.getHasBabies() && this.field_70146_Z.nextInt(100) == 0) {
            MoCTools.findMobRider((Entity)this);
        }
        if (this.getIsPoisoning()) {
            ++this.poisontimer;
            if (this.poisontimer == 1) {
                MoCTools.playCustomSound((Entity)this, MoCSoundEvents.ENTITY_SCORPION_STING);
            }
            if (this.poisontimer > 50) {
                this.poisontimer = 0;
                this.setPoisoning(false);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (super.func_70097_a(damagesource, i)) {
            Entity entity = damagesource.func_76346_g();
            if (entity != this && entity instanceof EntityLivingBase && this.shouldAttackPlayers()) {
                this.func_70624_b((EntityLivingBase)entity);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean entitiesToIgnore(Entity entity) {
        return super.entitiesToIgnore(entity) || this.getIsTamed() && entity instanceof MoCEntityPetScorpion && ((MoCEntityPetScorpion)entity).getIsTamed();
    }

    public void swingArm() {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 1), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public boolean swingingTail() {
        return this.getIsPoisoning() && this.poisontimer < 15;
    }

    public void func_70645_a(DamageSource damagesource) {
        super.func_70645_a(damagesource);
        if (!this.field_70170_p.field_72995_K && this.getIsAdult()) {
            if (this.getHasBabies()) {
                int k = this.field_70146_Z.nextInt(5);
                for (int i = 0; i < k; ++i) {
                    MoCEntityScorpion babyScorpion;
                    switch (this.getType) {
                        case 2: {
                            babyScorpion = new MoCEntityCaveScorpion(this.field_70170_p);
                            break;
                        }
                        case 3: {
                            babyScorpion = new MoCEntityFireScorpion(this.field_70170_p);
                            break;
                        }
                        case 4: {
                            babyScorpion = new MoCEntityFrostScorpion(this.field_70170_p);
                            break;
                        }
                        case 5: {
                            babyScorpion = new MoCEntityUndeadScorpion(this.field_70170_p);
                            break;
                        }
                        default: {
                            babyScorpion = new MoCEntityDirtScorpion(this.field_70170_p);
                        }
                    }
                    babyScorpion.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    babyScorpion.setAdult(false);
                    babyScorpion.setAge(20);
                    babyScorpion.setType(this.getType);
                    this.field_70170_p.func_72838_d((Entity)babyScorpion);
                    MoCTools.playCustomSound((Entity)babyScorpion, SoundEvents.field_187886_fs);
                }
            }
            this.dropLegacyEgg();
        }
    }

    public void dropLegacyEgg() {
        int chance = MoCreatures.proxy.scorpionEggDropChance;
        if (this.getHasBabies()) {
            chance = MoCreatures.proxy.motherScorpionEggDropChance;
        }
        if (this.field_70146_Z.nextInt(100) < chance) {
            this.func_70099_a(new ItemStack((Item)MoCItems.mocegg, 1, this.getType + 40), 0.0f);
        }
    }

    protected SoundEvent func_184615_bR() {
        return MoCSoundEvents.ENTITY_SCORPION_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return MoCSoundEvents.ENTITY_SCORPION_HURT;
    }

    protected SoundEvent func_184639_G() {
        if (!this.field_70170_p.field_72995_K) {
            MoCMessageHandler.INSTANCE.sendToAllAround((IMessage)new MoCMessageAnimation(this.func_145782_y(), 3), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.func_186058_p().func_186068_a(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0));
        }
        return MoCSoundEvents.ENTITY_SCORPION_AMBIENT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.5f);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setHasBabies(nbttagcompound.func_74767_n("Babies"));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("Babies", this.getHasBabies());
    }

    public int func_70627_aG() {
        return 300;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    @Override
    public float getAdjustedYOffset() {
        return 30.0f;
    }

    @Override
    protected int getMaxAge() {
        return 120;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.75 - 0.15;
    }

    public void func_184232_k(Entity passenger) {
        double dist = 0.2;
        double newPosX = this.field_70165_t + dist * Math.sin(this.field_70761_aq / 57.29578f);
        double newPosZ = this.field_70161_v - dist * Math.cos(this.field_70761_aq / 57.29578f);
        passenger.func_70107_b(newPosX, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), newPosZ);
        passenger.field_70177_z = this.field_70177_z;
    }

    static class AIScorpionTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIScorpionTarget(MoCEntityScorpion scorpion, Class<T> classTarget, boolean checkSight) {
            super((EntityCreature)scorpion, classTarget, checkSight);
        }

        public boolean func_75250_a() {
            float f = this.field_75299_d.func_70013_c();
            return f < 0.5f && super.func_75250_a();
        }
    }

    static class AIScorpionAttack
    extends EntityAIAttackMelee {
        public AIScorpionAttack(MoCEntityScorpion scorpion, double speed, boolean useLongMemory) {
            super((EntityCreature)scorpion, speed, useLongMemory);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b(null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

