/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.hunter.MoCEntityLion;
import drzhark.mocreatures.entity.hunter.MoCEntityPanther;
import drzhark.mocreatures.entity.hunter.MoCEntityTiger;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.init.MoCLootTables;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class MoCEntityLeopard
extends MoCEntityBigCat {
    public MoCEntityLeopard(World world) {
        super(world);
        this.func_70105_a(1.165f, 1.01f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            this.checkSpawningBiome();
        }
        super.selectType();
    }

    @Override
    public boolean checkSpawningBiome() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos pos = new BlockPos(i, j, k);
        Biome currentbiome = MoCTools.biomeKind(this.field_70170_p, pos);
        try {
            if (BiomeDictionary.hasType((Biome)currentbiome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
                this.setType(2);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setType(1);
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        if (MoCreatures.proxy.legacyBigCatModels) {
            if (this.getType() == 2) {
                return MoCreatures.proxy.getModelTexture("big_cat_snow_leopard_legacy.png");
            }
            return MoCreatures.proxy.getModelTexture("big_cat_leopard_legacy.png");
        }
        if (this.getType() == 2) {
            return MoCreatures.proxy.getModelTexture("big_cat_snow_leopard.png");
        }
        return MoCreatures.proxy.getModelTexture("big_cat_leopard.png");
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.func_70093_af() || this.func_184207_aI())) {
            if (!this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this)) {
                player.field_70177_z = this.field_70177_z;
                player.field_70125_A = this.field_70125_A;
                this.setSitting(false);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (!this.getIsAdult()) {
            return null;
        }
        return MoCLootTables.LEOPARD;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        if (mate instanceof MoCEntityPanther && mate.getType() == 1) {
            return "Panthard";
        }
        if (mate instanceof MoCEntityTiger && mate.getType() == 1) {
            return "Leoger";
        }
        if (mate instanceof MoCEntityLion && mate.getType() == 2) {
            return "Liard";
        }
        return "Leopard";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        if (mate instanceof MoCEntityPanther && mate.getType() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityTiger && mate.getType() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityLion && mate.getType() == 2) {
            return 1;
        }
        return this.getType();
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        return mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getType() == this.getType() || mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1 || mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() == 1 || mate instanceof MoCEntityLion && ((MoCEntityLion)mate).getType() == 2;
    }

    @Override
    public int getMaxAge() {
        return 95;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        if (!this.getIsAdult() && (double)this.getAge() < (double)this.getMaxAge() * 0.8) {
            return false;
        }
        if (entity instanceof MoCEntityLeopard) {
            return false;
        }
        return entity.field_70131_O < 1.3f && entity.field_70130_N < 1.3f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.92f;
    }
}

