/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.entity.hunter;

import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.hunter.MoCEntityBigCat;
import drzhark.mocreatures.entity.hunter.MoCEntityLeopard;
import drzhark.mocreatures.entity.hunter.MoCEntityPanther;
import drzhark.mocreatures.entity.hunter.MoCEntityTiger;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.init.MoCItems;
import drzhark.mocreatures.init.MoCLootTables;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MoCEntityLion
extends MoCEntityBigCat {
    public MoCEntityLion(World world) {
        super(world);
        this.func_70105_a(1.25f, 1.275f);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    public void selectType() {
        if (this.getType() == 0) {
            if (this.field_70146_Z.nextInt(20) == 0) {
                this.setType(this.field_70146_Z.nextInt(2) + 6);
            } else {
                this.setType(this.field_70146_Z.nextInt(2) + 1);
            }
        }
        super.selectType();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.calculateMaxHealth());
        this.func_70606_j(this.func_110138_aP());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.calculateAttackDmg());
    }

    @Override
    public ResourceLocation getTexture() {
        if (MoCreatures.proxy.legacyBigCatModels) {
            switch (this.getType()) {
                case 6: 
                case 7: 
                case 8: {
                    return MoCreatures.proxy.getModelTexture("big_cat_white_lion_legacy.png");
                }
            }
            return MoCreatures.proxy.getModelTexture("big_cat_lion_legacy.png");
        }
        switch (this.getType()) {
            case 2: 
            case 3: {
                return MoCreatures.proxy.getModelTexture("big_cat_lion_male.png");
            }
            case 6: 
            case 7: 
            case 8: {
                return MoCreatures.proxy.getModelTexture("big_cat_white_lion.png");
            }
        }
        return MoCreatures.proxy.getModelTexture("big_cat_lion_female.png");
    }

    @Override
    public boolean hasMane() {
        return this.getIsAdult() && (this.getType() == 2 || this.getType() == 3 || this.getType() == 7);
    }

    @Override
    public boolean isFlyer() {
        return this.getType() == 3 || this.getType() == 5 || this.getType() == 8;
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        Boolean tameResult = this.processTameInteract(player, hand);
        if (tameResult != null) {
            return tameResult;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && this.getIsTamed() && (this.getType() == 2 || this.getType() == 7) && stack.func_77973_b() == MoCItems.essencelight) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
            this.setType(this.getType() + 1);
            return true;
        }
        if (!(!this.getIsRideable() || !this.getIsAdult() || this.getIsChested() && player.func_70093_af() || this.func_184207_aI())) {
            if (!this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this)) {
                player.field_70177_z = this.field_70177_z;
                player.field_70125_A = this.field_70125_A;
                this.setSitting(false);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (!this.getIsAdult()) {
            return null;
        }
        return MoCLootTables.LION;
    }

    @Override
    public String getOffspringClazz(IMoCTameable mate) {
        if (mate instanceof MoCEntityTiger && mate.getType() < 3) {
            return "Liger";
        }
        if (this.getType() == 2 && mate instanceof MoCEntityLeopard && mate.getType() == 1) {
            return "Liard";
        }
        if (this.getType() == 2 && mate instanceof MoCEntityPanther && mate.getType() == 1) {
            return "Lither";
        }
        return "Lion";
    }

    @Override
    public int getOffspringTypeInt(IMoCTameable mate) {
        int x = 0;
        if (mate instanceof MoCEntityTiger && mate.getType() < 3) {
            return 1;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityLeopard && mate.getType() == 1) {
            return 1;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityPanther && mate.getType() == 1) {
            return 1;
        }
        if (mate instanceof MoCEntityLion) {
            int lionMateType = mate.getType();
            if (this.getType() == 1 && lionMateType == 2) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 2 && lionMateType == 1) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 6 && lionMateType == 7) {
                x = this.field_70146_Z.nextInt(2) + 6;
            }
            if (this.getType() == 7 && lionMateType == 6) {
                x = this.field_70146_Z.nextInt(2) + 6;
            }
            if (this.getType() == 7 && lionMateType == 1) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 6 && lionMateType == 2) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 1 && lionMateType == 7) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
            if (this.getType() == 2 && lionMateType == 6) {
                x = this.field_70146_Z.nextInt(2) + 1;
            }
        }
        return x;
    }

    @Override
    public boolean compatibleMate(Entity mate) {
        if (this.getType() == 2 && mate instanceof MoCEntityTiger && ((MoCEntityTiger)mate).getType() < 3) {
            return true;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityLeopard && ((MoCEntityLeopard)mate).getType() == 1) {
            return true;
        }
        if (this.getType() == 2 && mate instanceof MoCEntityPanther && ((MoCEntityPanther)mate).getType() == 1) {
            return true;
        }
        if (mate instanceof MoCEntityLion) {
            return this.getOffspringTypeInt((MoCEntityLion)mate) != 0;
        }
        return false;
    }

    @Override
    public boolean readytoBreed() {
        return (this.getType() < 3 || this.getType() == 6 || this.getType() == 7) && super.readytoBreed();
    }

    public float calculateMaxHealth() {
        if (this.getType() == 2 || this.getType() == 7) {
            return 35.0f;
        }
        if (this.getType() == 4) {
            return 40.0f;
        }
        return 30.0f;
    }

    @Override
    public int getMaxAge() {
        if (this.getType() == 1 || this.getType() == 6) {
            return 110;
        }
        if (this.getType() == 9) {
            return 100;
        }
        return 120;
    }

    public double calculateAttackDmg() {
        if (this.getType() == 6 || this.getType() == 7 || this.getType() == 8) {
            return 7.5;
        }
        return 7.0;
    }

    @Override
    public boolean canAttackTarget(EntityLivingBase entity) {
        if (!this.getIsAdult() && (double)this.getAge() < (double)this.getMaxAge() * 0.8) {
            return false;
        }
        if (entity instanceof MoCEntityLion) {
            return false;
        }
        return entity.field_70131_O < 2.0f && entity.field_70130_N < 2.0f;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.92f;
    }
}

