/*
 * Decompiled with CFR 0.152.
 */
package drzhark.mocreatures.network.command;

import drzhark.mocreatures.MoCTools;
import drzhark.mocreatures.MoCreatures;
import drzhark.mocreatures.entity.tameable.IMoCTameable;
import drzhark.mocreatures.entity.tameable.MoCPetData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandMoCPets
extends CommandBase {
    private static final List<String> commands = new ArrayList<String>();
    private static final List<String> aliases = new ArrayList<String>();

    public String func_71517_b() {
        return "mocpets";
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "commands.mocpets.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        int unloadedCount = 0;
        int loadedCount = 0;
        ArrayList<Integer> foundIds = new ArrayList<Integer>();
        ArrayList<String> tamedlist = new ArrayList<String>();
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        UUID playerId = player.func_110124_au();
        Integer[] integerArray = DimensionManager.getIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dimension = integerArray[i];
            WorldServer world = DimensionManager.getWorld((int)dimension);
            for (int j = 0; j < world.field_72996_f.size(); ++j) {
                IMoCTameable mocreature;
                Entity entity = (Entity)world.field_72996_f.get(j);
                if (!IMoCTameable.class.isAssignableFrom(entity.getClass()) || (mocreature = (IMoCTameable)entity).getOwnerId() == null || !mocreature.getOwnerId().equals(playerId)) continue;
                ++loadedCount;
                foundIds.add(mocreature.getOwnerPetId());
                tamedlist.add(TextFormatting.WHITE + "Found pet with " + TextFormatting.DARK_AQUA + "Type" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + ((EntityLiving)mocreature).func_70005_c_() + TextFormatting.DARK_AQUA + ", Name" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature.getPetName() + TextFormatting.DARK_AQUA + ", Owner" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature.getOwnerId() + TextFormatting.DARK_AQUA + ", PetId" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + mocreature.getOwnerPetId() + TextFormatting.DARK_AQUA + ", Dimension" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + entity.field_71093_bK + TextFormatting.DARK_AQUA + ", Pos" + TextFormatting.WHITE + ":" + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70165_t) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70163_u) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(entity.field_70161_v));
            }
        }
        MoCPetData ownerPetData = MoCreatures.instance.mapData.getPetData(player.func_110124_au());
        if (ownerPetData != null) {
            MoCreatures.instance.mapData.forceSave();
            for (int i = 0; i < ownerPetData.getTamedList().func_74745_c(); ++i) {
                NBTTagCompound nbt = ownerPetData.getTamedList().func_150305_b(i);
                if (!nbt.func_74764_b("PetId") || foundIds.contains(nbt.func_74762_e("PetId"))) continue;
                ++unloadedCount;
                double posX = nbt.func_150295_c("Pos", 6).func_150309_d(0);
                double posY = nbt.func_150295_c("Pos", 6).func_150309_d(1);
                double posZ = nbt.func_150295_c("Pos", 6).func_150309_d(2);
                if (nbt.func_74767_n("InAmulet")) {
                    tamedlist.add(TextFormatting.WHITE + "Found unloaded pet in " + TextFormatting.DARK_PURPLE + "AMULET" + TextFormatting.WHITE + " with " + TextFormatting.DARK_AQUA + "Type" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("id").replace("MoCreatures.", "") + TextFormatting.DARK_AQUA + ", Name" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Name") + TextFormatting.DARK_AQUA + ", Owner" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Owner") + TextFormatting.DARK_AQUA + ", PetId" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74762_e("PetId") + TextFormatting.WHITE + ".");
                    continue;
                }
                tamedlist.add(TextFormatting.WHITE + "Found unloaded pet with " + TextFormatting.DARK_AQUA + "Type" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("id").replace("MoCreatures.", "") + TextFormatting.DARK_AQUA + ", Name" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Name") + TextFormatting.DARK_AQUA + ", Owner" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74779_i("Owner") + TextFormatting.DARK_AQUA + ", PetId" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74762_e("PetId") + TextFormatting.DARK_AQUA + ", Dimension" + TextFormatting.WHITE + ":" + TextFormatting.GREEN + nbt.func_74762_e("Dimension") + TextFormatting.DARK_AQUA + ", Pos" + TextFormatting.WHITE + ":" + TextFormatting.LIGHT_PURPLE + Math.round(posX) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posY) + TextFormatting.WHITE + ", " + TextFormatting.LIGHT_PURPLE + Math.round(posZ));
            }
        }
        if (tamedlist.size() > 0) {
            this.sendPageHelp(sender, (byte)10, tamedlist, args);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Loaded tamed count : " + TextFormatting.AQUA + loadedCount + TextFormatting.WHITE + ", Unloaded count : " + TextFormatting.AQUA + unloadedCount + TextFormatting.WHITE + ", Total count : " + TextFormatting.AQUA + (ownerPetData != null ? ownerPetData.getTamedList().func_74745_c() : 0), new Object[0]));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("Loaded tamed count : " + TextFormatting.AQUA + loadedCount + TextFormatting.WHITE + (!MoCreatures.isServer() ? ", Unloaded Count : " + TextFormatting.AQUA + unloadedCount + TextFormatting.WHITE + ", Total count : " + TextFormatting.AQUA + (loadedCount + unloadedCount) : ""), new Object[0]));
        }
    }

    protected List<String> getSortedPossibleCommands(ICommandSender par1ICommandSender) {
        Collections.sort(commands);
        return commands;
    }

    public boolean teleportLoadedPet(WorldServer world, EntityPlayerMP player, int petId, String petName, ICommandSender par1ICommandSender) {
        for (int j = 0; j < world.field_72996_f.size(); ++j) {
            Entity entity = (Entity)world.field_72996_f.get(j);
            if (!IMoCTameable.class.isAssignableFrom(entity.getClass()) || ((IMoCTameable)entity).getPetName().equals("") || ((IMoCTameable)entity).getOwnerPetId() != petId) continue;
            NBTTagCompound compound = new NBTTagCompound();
            entity.func_189511_e(compound);
            if (compound.func_82582_d() || compound.func_74779_i("Owner").isEmpty()) continue;
            String owner = compound.func_74779_i("Owner");
            String name = compound.func_74779_i("Name");
            if (owner.isEmpty() || !owner.equalsIgnoreCase(player.func_70005_c_())) continue;
            if (entity.field_71093_bK == player.field_71093_bK) {
                entity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            } else if (!player.field_70170_p.field_72995_K) {
                Entity newEntity = EntityList.func_191304_a(entity.getClass(), (World)player.field_70170_p);
                if (newEntity != null) {
                    MoCTools.copyDataFromOld(newEntity, entity);
                    newEntity.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    DimensionManager.getWorld((int)player.field_71093_bK).func_72838_d(newEntity);
                }
                if (entity.func_184187_bx() != null) {
                    entity.func_184187_bx().func_184210_p();
                }
                entity.field_70128_L = true;
                world.func_82742_i();
                DimensionManager.getWorld((int)player.field_71093_bK).func_82742_i();
            }
            par1ICommandSender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.GREEN + name + TextFormatting.WHITE + " has been tp'd to location " + Math.round(player.field_70165_t) + ", " + Math.round(player.field_70163_u) + ", " + Math.round(player.field_70161_v) + " in dimension " + player.field_71093_bK, new Object[0]));
            return true;
        }
        return false;
    }

    public void sendCommandHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("\u00a72Listing MoCreatures commands", new Object[0]));
        for (String command : commands) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(command, new Object[0]));
        }
    }

    public void sendPageHelp(ICommandSender sender, byte pagelimit, ArrayList<String> list, String[] par2ArrayOfStr) {
        int x = (list.size() - 1) / pagelimit;
        int j = 0;
        if (par2ArrayOfStr.length > 0 && Character.isDigit(par2ArrayOfStr[0].charAt(0))) {
            try {
                j = CommandMoCPets.func_175764_a((String)par2ArrayOfStr[0], (int)1, (int)(x + 1)) - 1;
            }
            catch (NumberInvalidException numberinvalidexception) {
                numberinvalidexception.printStackTrace();
            }
        }
        int k = Math.min((j + 1) * pagelimit, list.size());
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.DARK_GREEN + "--- Showing MoCreatures Help Info " + TextFormatting.AQUA + (j + 1) + TextFormatting.WHITE + " of " + TextFormatting.AQUA + (x + 1) + TextFormatting.GRAY + " (/mocpets <page>)" + TextFormatting.DARK_GREEN + "---", new Object[0]));
        for (int l = j * pagelimit; l < k; ++l) {
            String tamedInfo = list.get(l);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation(tamedInfo, new Object[0]));
        }
    }

    static {
        commands.add("/mocpets");
        aliases.add("mocpets");
    }
}

