/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.integration.sponge;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Maps;
import io.github.lxgaming.sledgehammer.SledgehammerPlatform;
import io.github.lxgaming.sledgehammer.integration.Integration;
import io.github.lxgaming.sledgehammer.util.Locale;
import io.github.lxgaming.sledgehammer.util.text.adapter.LocaleAdapter;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeIntegration_Border
extends Integration {
    private final Map<UUID, Long> cooldown = Maps.newHashMap();

    @Override
    public boolean prepare() {
        this.addDependency("sponge");
        this.state(SledgehammerPlatform.State.INITIALIZATION);
        return true;
    }

    @Override
    public void execute() throws Exception {
        Sponge.getEventManager().registerListeners(SledgehammerPlatform.getInstance().getContainer(), (Object)this);
    }

    @Listener(order=Order.LATE)
    public void onClientConnectionDisconnect(ClientConnectionEvent.Disconnect event) {
        this.cooldown.remove(event.getTargetEntity().getUniqueId());
    }

    @Listener(order=Order.EARLY)
    public void onClientConnectionJoin(ClientConnectionEvent.Join event) {
        this.cooldown.put(event.getTargetEntity().getUniqueId(), System.currentTimeMillis());
    }

    @Listener(order=Order.LATE)
    public void onMoveEntity(MoveEntityEvent event, @Root Player player) {
        Location location = event.getToTransform().getLocation();
        World world = (World)location.getExtent();
        long radius = (long)Math.floor(world.getWorldBorder().getDiameter() / 2.0) + 1L;
        Vector3d displacement = location.getPosition().sub(world.getWorldBorder().getCenter()).abs();
        if (displacement.getX() > (double)radius || displacement.getZ() > (double)radius) {
            event.setCancelled(true);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.cooldown.getOrDefault(player.getUniqueId(), 0L) < 5000L) {
                return;
            }
            this.cooldown.put(player.getUniqueId(), currentTime);
            LocaleAdapter.sendMessage((EntityPlayer)((EntityPlayerMP)player), Locale.MESSAGE_MOVE_OUTSIDE_BORDER, new Object[0]);
        }
    }
}

