/*
 * Decompiled with CFR 0.152.
 */
package io.github.lxgaming.sledgehammer.util;

import io.github.lxgaming.sledgehammer.launch.SledgehammerLaunch;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.util.PrettyPrinter;

public class PrettyPrinterProxy {
    private static final MethodHandle levelMethodHandle;
    private static final MethodHandle logMethodHandle;

    public static PrettyPrinter error(PrettyPrinter prettyPrinter) {
        try {
            if (levelMethodHandle == null || logMethodHandle == null) {
                throw new IllegalStateException("MethodHandle is unavailable");
            }
            Object levelObject = levelMethodHandle.invoke("ERROR");
            Object object = logMethodHandle.invoke(prettyPrinter, levelObject);
            return (PrettyPrinter)object;
        }
        catch (Throwable t2) {
            SledgehammerLaunch.getLogger().error("Encountered an error while pretty printing", t2);
            return prettyPrinter;
        }
    }

    static {
        MethodHandle logMethodHandleTemporary;
        MethodHandle levelMethodHandleTemporary;
        Class<Object> parameterClass;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            parameterClass = Class.forName("org.spongepowered.asm.logging.Level");
        }
        catch (Throwable t2) {
            parameterClass = Level.class;
        }
        try {
            Method valueOfMethod = parameterClass.getMethod("valueOf", String.class);
            levelMethodHandleTemporary = lookup.unreflect(valueOfMethod);
            Method logMethod = PrettyPrinter.class.getMethod("log", parameterClass);
            logMethodHandleTemporary = lookup.unreflect(logMethod);
        }
        catch (Throwable t3) {
            levelMethodHandleTemporary = null;
            logMethodHandleTemporary = null;
        }
        levelMethodHandle = levelMethodHandleTemporary;
        logMethodHandle = logMethodHandleTemporary;
    }
}

