/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.codechickenlib.mixin;

import codechicken.lib.packet.PacketCustom;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PacketCustom.class}, remap=false)
public abstract class UTPacketCustomRetainMixin {
    @Inject(method={"sendToClients(Lnet/minecraft/network/Packet;)V"}, at={@At(value="HEAD")})
    private static void utRetainForAllClients(Packet<INetHandler> packet, CallbackInfo ci) {
        UTPacketCustomRetainMixin.ut$retainForPlayers(packet, player -> true);
    }

    @Inject(method={"sendToAllAround"}, at={@At(value="HEAD")})
    private static void utRetainForAllAround(Packet<INetHandler> packet, double x, double y, double z, double range, int dim, CallbackInfo ci) {
        UTPacketCustomRetainMixin.ut$retainForPlayers(packet, player -> {
            if (player.field_71093_bK != dim) {
                return false;
            }
            double dx = player.field_70165_t - x;
            double dy = player.field_70163_u - y;
            double dz = player.field_70161_v - z;
            return dx * dx + dy * dy + dz * dz < range * range;
        });
    }

    @Inject(method={"sendToDimension(Lnet/minecraft/network/Packet;I)V"}, at={@At(value="HEAD")})
    private static void utRetainForAllInDimension(Packet<INetHandler> packet, int dim, CallbackInfo ci) {
        UTPacketCustomRetainMixin.ut$retainForPlayers(packet, player -> player.field_71093_bK == dim);
    }

    @Inject(method={"sendToChunk(Lnet/minecraft/network/Packet;Lnet/minecraft/world/World;II)V"}, at={@At(value="HEAD")})
    private static void utRetainForAllInChunk(Packet<INetHandler> packet, World world, int chunkX, int chunkZ, CallbackInfo ci) {
        PlayerChunkMapEntry playersInChunk = ((WorldServer)world).func_184164_w().func_187301_b(chunkX, chunkZ);
        if (playersInChunk != null) {
            UTPacketCustomRetainMixin.ut$retainForPlayers(packet, arg_0 -> ((PlayerChunkMapEntry)playersInChunk).func_187275_d(arg_0));
        }
    }

    @Inject(method={"sendToOps(Lnet/minecraft/network/Packet;)V"}, at={@At(value="HEAD")})
    private static void utRetainForOps(Packet<INetHandler> packet, CallbackInfo ci) {
        UTPacketCustomRetainMixin.ut$retainForPlayers(packet, player -> FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH()));
    }

    @Unique
    private static void ut$retainForPlayers(Packet<INetHandler> packet, Predicate<EntityPlayerMP> condition) {
        if (packet instanceof FMLProxyPacket) {
            List playerList = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
            Predicate<EntityPlayerMP> hasNetworkDispatcher = player -> player.field_71135_a.field_147371_a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get() != null;
            int retainCount = (int)(playerList.stream().filter(condition.and(hasNetworkDispatcher)).count() - 1L);
            if (retainCount > 0) {
                ((FMLProxyPacket)packet).payload().retain(retainCount);
            }
        }
    }
}

