/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.nuclearcraft.mixin;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.config.UTConfigMods;
import nc.config.NCConfig;
import nc.radiation.environment.RadiationEnvironmentHandler;
import nc.radiation.environment.RadiationEnvironmentInfo;
import nc.tile.radiation.ITileRadiationEnvironment;
import nc.util.FourPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RadiationEnvironmentHandler.class}, remap=false)
public class UTRadiationEnvironmentHandlerMixin {
    @Unique
    private static final Queue<Pair<FourPos, RadiationEnvironmentInfo>> ENVIRONMENT_QUEUE = UTConfigMods.NUCLEARCRAFT.utNCRadiationEnvironmentMap == UTConfigMods.NuclearCraftCategory.EnumMaps.CONCURRENT_LINKED_QUEUE ? new ConcurrentLinkedQueue() : null;
    @Mutable
    @Shadow
    @Final
    private static ConcurrentMap<FourPos, RadiationEnvironmentInfo> ENVIRONMENT;

    @Inject(method={"removeTile"}, at={@At(value="FIELD", target="Lnc/radiation/environment/RadiationEnvironmentHandler;ENVIRONMENT_BACKUP:Ljava/util/concurrent/ConcurrentMap;", opcode=178)}, cancellable=true)
    private static void utSkipRemoveFromBackup(CallbackInfo ci) {
        if (UTConfigMods.NUCLEARCRAFT.utNCRadiationEnvironmentMap != UTConfigMods.NuclearCraftCategory.EnumMaps.CONCURRENT_LINKED_QUEUE) {
            return;
        }
        ci.cancel();
    }

    @Redirect(method={"<clinit>"}, at=@At(value="FIELD", target="Lnc/radiation/environment/RadiationEnvironmentHandler;ENVIRONMENT:Ljava/util/concurrent/ConcurrentMap;"))
    private static void utUseEnvironmentLinkedMap(ConcurrentMap<FourPos, RadiationEnvironmentInfo> map) {
        if (UTConfigMods.NUCLEARCRAFT.utNCRadiationEnvironmentMap == UTConfigMods.NuclearCraftCategory.EnumMaps.CONCURRENT_LINKED_HASHMAP) {
            if (UTConfigGeneral.DEBUG.utDebugToggle) {
                UniversalTweaks.LOGGER.debug("UTRadiationEnvironmentHandler ::: Concurrent linked hash map");
            }
            ENVIRONMENT = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(9223372034707292160L).build();
        } else {
            ENVIRONMENT = new ConcurrentHashMap<FourPos, RadiationEnvironmentInfo>();
        }
    }

    @Inject(method={"updateRadiationEnvironment"}, at={@At(value="HEAD")}, cancellable=true)
    private void utUseEnvironmentQueue(TickEvent.WorldTickEvent event, CallbackInfo ci) {
        if (UTConfigMods.NUCLEARCRAFT.utNCRadiationEnvironmentMap != UTConfigMods.NuclearCraftCategory.EnumMaps.CONCURRENT_LINKED_QUEUE) {
            return;
        }
        ci.cancel();
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.END || event.side == Side.CLIENT || !(event.world instanceof WorldServer)) {
            return;
        }
        int dim = event.world.field_73011_w.getDimension();
        int count = (1 + NCConfig.radiation_world_chunks_per_tick) / 2;
        boolean queueEmpty = false;
        while (count > 0 && !(queueEmpty = ENVIRONMENT_QUEUE.isEmpty())) {
            --count;
            Map.Entry environmentEntry = (Map.Entry)ENVIRONMENT_QUEUE.poll();
            if (environmentEntry == null) break;
            FourPos pos = (FourPos)environmentEntry.getKey();
            RadiationEnvironmentInfo info = (RadiationEnvironmentInfo)environmentEntry.getValue();
            if (pos.getDimension() == dim) {
                for (Map.Entry infoEntry : info.tileMap.entrySet()) {
                    ((ITileRadiationEnvironment)infoEntry.getValue()).handleRadiationEnvironmentInfo(info);
                }
            }
            ENVIRONMENT.put(pos, info);
        }
        if (queueEmpty) {
            for (Map.Entry environmentEntry : ENVIRONMENT.entrySet()) {
                ENVIRONMENT_QUEUE.add((Pair<FourPos, RadiationEnvironmentInfo>)Pair.of(environmentEntry.getKey(), environmentEntry.getValue()));
            }
            ENVIRONMENT.clear();
        }
    }
}

