/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.rftoolsdimension.mixin;

import java.util.Iterator;
import mcjty.rftoolsdim.dimensions.RfToolsDimensionManager;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigMods;
import mod.acgaming.universaltweaks.mods.rftoolsdimension.mixin.UTRfToolsDimensionManagerAccessor;
import net.minecraftforge.common.DimensionManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RfToolsDimensionManager.class}, remap=false)
public abstract class UTDimensionManager {
    @Shadow
    private static RfToolsDimensionManager clientInstance;

    @Inject(method={"cleanupDimensionInformation"}, at={@At(value="HEAD")})
    private static void utClearClientInstance(CallbackInfo ci) {
        if (!UTConfigMods.RFTOOLS_DIMENSIONS.utFullyUnregisterDimensions) {
            return;
        }
        if (clientInstance != null) {
            UniversalTweaks.LOGGER.info("UTDimensionManager ::: Cleaning up RFTools dimensions for the clientInstance");
            Iterator iterator = clientInstance.getDimensions().keySet().iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                if (DimensionManager.isDimensionRegistered((int)id)) {
                    UniversalTweaks.LOGGER.info("UTDimensionManager ::: Unregister dimension: " + id);
                    try {
                        DimensionManager.unregisterDimension((int)id);
                    }
                    catch (Exception e) {
                        UniversalTweaks.LOGGER.error("UTDimensionManager ::: Error unregistering dimension: " + id, (Throwable)e);
                    }
                    continue;
                }
                UniversalTweaks.LOGGER.info("UTDimensionManager ::: Already unregistered! Dimension: " + id);
            }
            clientInstance.getDimensions().clear();
            ((UTRfToolsDimensionManagerAccessor)clientInstance).getDimensionToID().clear();
            ((UTRfToolsDimensionManagerAccessor)clientInstance).getDimensionInformation().clear();
            ((UTRfToolsDimensionManagerAccessor)clientInstance).getReclaimedIds().clear();
            clientInstance = null;
        }
    }
}

