/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.woot;

import ipsis.Woot;
import ipsis.woot.util.DebugSetup;
import java.util.List;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.mods.woot.ITartarusCleaner;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;

public class UTWootTicketManager {
    public static final ChunkPos CHUNK = new ChunkPos(0, 0);
    public static ForgeChunkManager.Ticket ticket;

    public static void forceChunk(World world, int boxId) {
        WorldServer worldWoot = Woot.wootDimensionManager.getWorldServer(world);
        if (ticket == null) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "UTWootTicketManager:callback", (Object)"requesting a ticket");
            ticket = ForgeChunkManager.requestTicket((Object)Woot.instance, (World)worldWoot, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket == null) {
                UniversalTweaks.LOGGER.error("UTWootTicketManager ::: Could not get a ticket for Tartarus (Woot)! Please report to Universal Tweaks.");
                return;
            }
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "UTWootTicketManager:callback", (Object)("forcing chunk for boxId " + boxId));
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)CHUNK);
    }

    public static void releaseChunk(int boxId) {
        if (ticket == null) {
            return;
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "UTWootTicketManager:callback", (Object)("trying to release chunk for boxId " + boxId));
        if (!((ITartarusCleaner)Woot.tartarusManager).ut$areBoxesInUse()) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "UTWootTicketManager:callback", (Object)"releasing ticket");
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            ticket = null;
        }
    }

    public static void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)Woot.instance, UTWootTicketManager::callback);
    }

    private static void callback(List<ForgeChunkManager.Ticket> tickets, World world) {
        int dim = world.field_73011_w.getDimension();
        if (dim != Woot.wootDimensionManager.getDimensionId()) {
            return;
        }
        if (tickets.size() > 1) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
        ticket = tickets.get(0);
        ((ITartarusCleaner)Woot.tartarusManager).ut$freeBoxes();
    }
}

