/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.block.TileBase;
import pl.asie.charset.module.crafting.cauldron.BlockCauldronCharset;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;
import pl.asie.charset.module.crafting.cauldron.api.ICauldron;

public class TileCauldronCharset
extends TileBase
implements ICauldron,
IFluidHandler,
IFluidTankProperties {
    private FluidStack stack;

    public boolean isEmptyOrWater() {
        return this.stack == null || this.stack.getFluid() == FluidRegistry.WATER;
    }

    public void readNBTData(NBTTagCompound compound, boolean isClient) {
        super.readNBTData(compound, isClient);
        this.stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
        if (isClient) {
            this.rebuildFromStack(false);
            this.markBlockForRenderUpdate();
        }
    }

    public NBTTagCompound writeNBTData(NBTTagCompound compound, boolean isClient) {
        compound = super.writeNBTData(compound, isClient);
        if (this.stack != null) {
            this.stack.writeToNBT(compound);
        }
        return compound;
    }

    public void rebuildFromStack(boolean emitUpdate) {
        this.func_70296_d();
        IBlockState currState = this.field_145850_b.func_180495_p(this.field_174879_c);
        IBlockState state = CharsetCraftingCauldron.blockCauldron.func_176223_P().func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(this.isEmptyOrWater() ? this.getVanillaLevelValue() : 0));
        if (currState != state) {
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 0);
            if (!this.field_145850_b.field_72995_K && emitUpdate) {
                this.markBlockForUpdate();
            }
        }
    }

    private int getVanillaLevelValue() {
        int bottles;
        if (CharsetCraftingCauldron.waterBottleSize == 0) {
            return this.getComparatorValue(15);
        }
        int maxBottles = 1000 / CharsetCraftingCauldron.waterBottleSize;
        int n = bottles = this.stack != null ? this.stack.amount / CharsetCraftingCauldron.waterBottleSize : 0;
        if (bottles <= 2) {
            return bottles;
        }
        if (bottles == maxBottles) {
            return 3;
        }
        return 2;
    }

    private int levelToAmount(int level) {
        if (CharsetCraftingCauldron.waterBottleSize != 0) {
            return level * CharsetCraftingCauldron.waterBottleSize;
        }
        switch (level) {
            default: {
                return 0;
            }
            case 1: {
                return 334;
            }
            case 2: {
                return 667;
            }
            case 3: 
        }
        return 1000;
    }

    public void rebuildFromVanillaLevel(IBlockState state) {
        if (this.isEmptyOrWater()) {
            FluidStack oldStack = this.stack;
            int oldLevel = this.getVanillaLevelValue();
            int newLevel = (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a);
            int oldAmount = oldStack != null ? oldStack.amount : 0;
            int oldLAmount = this.levelToAmount(oldLevel);
            int newLAmount = this.levelToAmount(newLevel);
            int newAmount = oldAmount + newLAmount - oldLAmount;
            if (oldLevel == 0 && newLevel == 3) {
                newAmount = this.getCapacity();
            } else if (oldLevel == 3 && newLevel == 0) {
                newAmount = 0;
            }
            if (newAmount == oldAmount) {
                return;
            }
            this.stack = newAmount <= 0 ? null : (newAmount > this.getCapacity() ? new FluidStack(FluidRegistry.WATER, this.getCapacity()) : new FluidStack(FluidRegistry.WATER, newAmount));
            int currLevel = newLevel;
            int desiredLevel = this.getVanillaLevelValue();
            if (currLevel != desiredLevel) {
                this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(desiredLevel)), 3);
                this.field_145850_b.func_175666_e(this.field_174879_c, (Block)CharsetCraftingCauldron.blockCauldron);
            }
        }
    }

    public int getComparatorValue(int max) {
        if (CharsetCraftingCauldron.waterBottleSize != 0) {
            int v = this.stack == null ? 0 : (this.stack.amount + (CharsetCraftingCauldron.waterBottleSize - 1)) / CharsetCraftingCauldron.waterBottleSize;
            return MathHelper.func_76125_a((int)v, (int)0, (int)max);
        }
        if (this.stack == null) {
            return 0;
        }
        if (this.stack.amount <= 333) {
            return 0;
        }
        if (this.stack.amount <= 666) {
            return 1;
        }
        if (this.stack.amount <= 999) {
            return 2;
        }
        return 3;
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public FluidStack getContents() {
        return this.stack;
    }

    protected void setContents(FluidStack stack) {
        int oldC = this.getComparatorValue(15);
        if (stack != null && stack.amount <= 0) {
            stack = null;
        }
        this.stack = stack;
        if (this.stack != null && this.stack.amount > this.getCapacity()) {
            ModCharset.logger.warn("Something tried to overflow cauldron @ " + this.getCauldronPos() + " with " + this.stack.amount + " mB of " + this.stack.getLocalizedName() + "!");
            this.stack = stack.copy();
            this.stack.amount = this.getCapacity();
        }
        this.rebuildFromStack(false);
        this.markBlockForUpdate();
        if (oldC != this.getComparatorValue(15)) {
            this.field_145850_b.func_175666_e(this.field_174879_c, (Block)CharsetCraftingCauldron.blockCauldron);
        }
    }

    public int getCapacity() {
        return 1000;
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return !fluidStack.getFluid().isGaseous(fluidStack);
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return true;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (this.stack != null && !resource.isFluidEqual(this.stack)) {
            boolean isOkay = false;
            if (resource.getFluid() == FluidRegistry.WATER && this.stack.getFluid() == CharsetCraftingCauldron.dyedWater) {
                isOkay = true;
            }
            if (!isOkay) {
                return 0;
            }
        }
        int toFill = Math.min(this.stack != null ? this.getCapacity() - this.stack.amount : this.getCapacity(), resource.amount);
        if (doFill) {
            int oldC = this.getComparatorValue(15);
            if (this.stack == null) {
                this.stack = new FluidStack(resource, toFill);
            } else {
                this.stack.amount += toFill;
            }
            this.rebuildFromStack(false);
            this.markBlockForUpdate();
            if (oldC != this.getComparatorValue(15)) {
                this.field_145850_b.func_175666_e(this.field_174879_c, (Block)CharsetCraftingCauldron.blockCauldron);
            }
        }
        return toFill;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.stack == null || !resource.isFluidEqual(this.stack)) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.stack == null) {
            return null;
        }
        FluidStack drainedStack = new FluidStack(this.stack, Math.min(this.stack.amount, maxDrain));
        if (drainedStack.amount == 0) {
            return null;
        }
        if (doDrain) {
            int oldC = this.getComparatorValue(15);
            if (drainedStack.amount == this.stack.amount) {
                this.stack = null;
            } else {
                this.stack.amount -= drainedStack.amount;
            }
            this.rebuildFromStack(false);
            this.markBlockForUpdate();
            if (oldC != this.getComparatorValue(15)) {
                this.field_145850_b.func_175666_e(this.field_174879_c, (Block)CharsetCraftingCauldron.blockCauldron);
            }
        }
        return drainedStack;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public float getFluidHeight() {
        return 6.0f + (this.stack != null ? (float)this.stack.amount * 9.0f / 1000.0f : 0.0f);
    }

    @Override
    public World getCauldronWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getCauldronPos() {
        return this.func_174877_v();
    }

    @Override
    public Collection<EntityItem> getCauldronItemEntities(boolean immersed) {
        AxisAlignedBB axisAlignedBB = BlockCauldronCharset.AABB_INSIDE;
        if (immersed) {
            axisAlignedBB = new AxisAlignedBB(axisAlignedBB.field_72340_a, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c, axisAlignedBB.field_72336_d, (double)this.getFluidHeight(), axisAlignedBB.field_72334_f);
        }
        return this.field_145850_b.func_72872_a(EntityItem.class, axisAlignedBB.func_186670_a(this.field_174879_c));
    }
}

