/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.cauldron.fluid;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.module.crafting.cauldron.CharsetCraftingCauldron;
import pl.asie.charset.module.crafting.cauldron.fluid.FluidPotion;

public class PotionFluidContainerItem
implements IFluidHandlerItem,
ICapabilityProvider {
    private ItemStack container = ItemStack.field_190927_a;

    public PotionFluidContainerItem() {
    }

    public PotionFluidContainerItem(ItemStack container) {
        this.container = container;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this) : null);
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        if (this.container.func_77973_b() instanceof ItemPotion) {
            FluidPotion fluid;
            if (PotionUtils.func_185191_c((ItemStack)this.container) == PotionTypes.field_185230_b) {
                return new FluidStack(FluidRegistry.WATER, CharsetCraftingCauldron.waterBottleSize);
            }
            if (this.container.func_77973_b() == Items.field_151068_bn) {
                fluid = CharsetCraftingCauldron.liquidPotion;
            } else if (this.container.func_77973_b() == Items.field_185155_bH) {
                fluid = CharsetCraftingCauldron.liquidSplashPotion;
            } else if (this.container.func_77973_b() == Items.field_185156_bI) {
                fluid = CharsetCraftingCauldron.liquidLingeringPotion;
            } else {
                return null;
            }
            FluidStack stack = new FluidStack((Fluid)fluid, CharsetCraftingCauldron.waterBottleSize);
            FluidPotion.copyFromPotionItem(stack, this.container);
            return stack;
        }
        return null;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), CharsetCraftingCauldron.waterBottleSize)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() > 1 || this.container.func_77973_b() != Items.field_151069_bo) {
            return 0;
        }
        if (resource.amount >= CharsetCraftingCauldron.waterBottleSize) {
            if (resource.getFluid().getName().equals("water")) {
                if (doFill) {
                    resource.amount -= CharsetCraftingCauldron.waterBottleSize;
                    this.container = new ItemStack((Item)Items.field_151068_bn);
                    PotionUtils.func_185188_a((ItemStack)this.container, (PotionType)PotionTypes.field_185230_b);
                }
                return CharsetCraftingCauldron.waterBottleSize;
            }
            if (resource.getFluid() instanceof FluidPotion) {
                if (doFill) {
                    FluidStack newStack = resource.copy();
                    newStack.amount = CharsetCraftingCauldron.waterBottleSize;
                    resource.amount -= newStack.amount;
                    this.container = new ItemStack(FluidPotion.getPotionItem(newStack.getFluid()));
                    FluidPotion.copyToPotionItem(this.container, newStack);
                }
                return CharsetCraftingCauldron.waterBottleSize;
            }
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() > 1) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained != null && resource.isFluidEqual(contained) && resource.amount >= contained.amount) {
            if (doDrain) {
                this.container = new ItemStack(Items.field_151069_bo);
            }
            return contained;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() > 1) {
            return null;
        }
        FluidStack contained = this.getFluid();
        if (contained != null && maxDrain >= contained.amount) {
            if (doDrain) {
                this.container = new ItemStack(Items.field_151069_bo);
            }
            return contained;
        }
        return null;
    }

    public static class Provider {
        public static final ResourceLocation LOCATION = new ResourceLocation("charset", "potion_fluid_container");
        public static CapabilityProviderFactory<IFluidHandlerItem> PROVIDER;

        @SubscribeEvent
        public void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
            if (((ItemStack)event.getObject()).func_77973_b() == Items.field_151069_bo || ((ItemStack)event.getObject()).func_77973_b() == Items.field_151068_bn || ((ItemStack)event.getObject()).func_77973_b() == Items.field_185155_bH || ((ItemStack)event.getObject()).func_77973_b() == Items.field_185156_bI) {
                if (PROVIDER == null) {
                    PROVIDER = new CapabilityProviderFactory(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
                }
                event.addCapability(LOCATION, PROVIDER.create((Object)new PotionFluidContainerItem((ItemStack)event.getObject())));
            }
        }
    }
}

