/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.compression;

import java.awt.image.BufferedImage;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.render.sprite.TextureAtlasSpriteCustom;
import pl.asie.charset.lib.utils.RenderUtils;

public final class CTMTextureFactory {
    private CTMTextureFactory() {
    }

    public static TextureAtlasSprite[] register(TextureMap map, ResourceLocation location) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[4];
        for (int i = 0; i < 4; ++i) {
            String s = String.format(location.toString() + "#%d", i);
            sprites[i] = map.getTextureExtry(s);
            if (sprites[i] != null) continue;
            sprites[i] = new SliceSprite(new ResourceLocation(s), location, i);
            map.setTextureEntry(sprites[i]);
        }
        return sprites;
    }

    protected static class SliceSprite
    extends TextureAtlasSpriteCustom {
        private final ResourceLocation location;
        private final boolean isLeft;
        private final boolean isRight;

        protected SliceSprite(ResourceLocation loc, ResourceLocation location, int i) {
            super(loc.toString());
            this.location = location;
            this.isLeft = (i & 2) != 0;
            this.isRight = (i & 1) != 0;
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean load(IResourceManager manager, ResourceLocation loc, Function<ResourceLocation, TextureAtlasSprite> getter) {
            BufferedImage sheet = null;
            if (sheet == null && (sheet = RenderUtils.getTextureImage((ResourceLocation)this.location, null)) == null) {
                ModCharset.logger.warn("Could not find texture sheet " + this.location + "!");
                return false;
            }
            int pieceWidth = sheet.getWidth() / 2;
            int pieceHeight = sheet.getHeight();
            int midX = pieceWidth / 2;
            int[] pixels = new int[pieceWidth * pieceHeight];
            sheet.getRGB(pieceWidth * (this.isLeft ? 1 : 0), 0, midX, pieceHeight, pixels, 0, pieceWidth);
            sheet.getRGB(pieceWidth * (this.isRight ? 1 : 0) + midX, 0, midX, pieceHeight, pixels, midX, pieceWidth);
            this.addFrameTextureData(pieceWidth, pieceHeight, pixels);
            return false;
        }
    }
}

