/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.compression;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.utils.EntityUtils;
import pl.asie.charset.module.crafting.compression.CompressionShape;
import pl.asie.charset.module.crafting.compression.grid.GridEntry;

public class CompressionShapeRenderer {
    public static final CompressionShapeRenderer INSTANCE = new CompressionShapeRenderer();
    private final Set<CompressionShape> shapes = Collections.newSetFromMap(new WeakHashMap());

    private CompressionShapeRenderer() {
    }

    public void addShape(CompressionShape shape) {
        this.shapes.add(shape);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.shapes.isEmpty()) {
            return;
        }
        Iterator<CompressionShape> shapeIterator = this.shapes.iterator();
        float partialTicks = event.getPartialTicks();
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        double oldSPX = TileEntityRendererDispatcher.field_147554_b;
        double oldSPY = TileEntityRendererDispatcher.field_147555_c;
        double oldSPZ = TileEntityRendererDispatcher.field_147552_d;
        TileEntityRendererDispatcher.field_147554_b = 0.0;
        TileEntityRendererDispatcher.field_147555_c = 0.0;
        TileEntityRendererDispatcher.field_147552_d = 0.0;
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        Entity cameraEntity = Minecraft.func_71410_x().func_175606_aa();
        Vec3d cameraPos = EntityUtils.interpolate((Entity)cameraEntity, (float)event.getPartialTicks());
        GlStateManager.func_179137_b((double)(-cameraPos.field_72450_a), (double)(-cameraPos.field_72448_b), (double)(-cameraPos.field_72449_c));
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        while (shapeIterator.hasNext()) {
            CompressionShape shape = shapeIterator.next();
            if (shape.isInvalid() || shape.world.field_73011_w.getDimension() != world.field_73011_w.getDimension()) {
                shapeIterator.remove();
                continue;
            }
            float progress = shape.getRenderProgress(partialTicks);
            if (progress == -1.0f) {
                shapeIterator.remove();
                continue;
            }
            if (progress <= 0.0f) continue;
            double volume = shape.grid.size();
            float[] scale = new float[3];
            int topI = shape.barrelOrientation.top.ordinal() >> 1;
            int leftI = shape.barrelOrientation.getNextRotationOnFace().top.ordinal() >> 1;
            int faceI = shape.barrelOrientation.facing.ordinal() >> 1;
            scale[topI] = 1.0f - progress * 2.0f / (float)shape.height;
            scale[leftI] = 1.0f - progress * 2.0f / (float)shape.width;
            scale[faceI] = (float)(volume / (double)(scale[topI] * (float)shape.height * scale[leftI] * (float)shape.width));
            if (scale[faceI] > 1.0f) {
                scale[faceI] = (scale[faceI] - 1.0f) * 1.61f + 1.0f;
            }
            Vec3d center = Vec3d.field_186680_a;
            for (GridEntry barrel : shape.grid) {
                center = center.func_178787_e(new Vec3d((Vec3i)barrel.getPos()).func_186678_a(1.0 / (double)shape.grid.size()));
            }
            center = center.func_72441_c(0.5, 0.5, 0.5);
            GlStateManager.func_179137_b((double)center.field_72450_a, (double)center.field_72448_b, (double)center.field_72449_c);
            GlStateManager.func_179152_a((float)scale[2], (float)scale[0], (float)scale[1]);
            GlStateManager.func_179137_b((double)(-center.field_72450_a), (double)(-center.field_72448_b), (double)(-center.field_72449_c));
            buffer.func_178969_c(0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            GlStateManager.func_179140_f();
            for (int i = 0; i < 2; ++i) {
                for (GridEntry barrel : shape.grid) {
                    textureManager.func_110577_a(TextureMap.field_110575_b);
                    int cl = world.func_175626_b(barrel.getPos(), 0);
                    int j = cl % 65536;
                    int k = cl / 65536;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (i == 0) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179091_B();
                        GlStateManager.func_179112_b((int)770, (int)771);
                        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                    }
                    try {
                        if (i == 0) {
                            IBlockState state = barrel.getState();
                            if (state.func_185901_i() == EnumBlockRenderType.MODEL) {
                                try {
                                    IBlockState renderState = state.func_185899_b((IBlockAccess)world, barrel.getPos());
                                    IBlockState renderStateExt = state.func_177230_c().getExtendedState(renderState, (IBlockAccess)world, barrel.getPos());
                                    IBakedModel model = brd.func_184389_a(renderState);
                                    brd.func_175019_b().func_187493_a((IBlockAccess)world, model, renderStateExt, barrel.getPos(), buffer, false, MathHelper.func_180186_a((Vec3i)barrel.getPos()));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            TileEntity tile = barrel.getTileEntity();
                            if (tile != null) {
                                textureManager.func_110577_a(TextureMap.field_110575_b);
                                TileEntityRendererDispatcher.field_147556_a.func_147549_a(tile, (double)barrel.getPos().func_177958_n(), (double)barrel.getPos().func_177956_o(), (double)barrel.getPos().func_177952_p(), 0.0f);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (i != 0) continue;
                    tessellator.func_78381_a();
                }
            }
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        TileEntityRendererDispatcher.field_147554_b = oldSPX;
        TileEntityRendererDispatcher.field_147555_c = oldSPY;
        TileEntityRendererDispatcher.field_147552_d = oldSPZ;
    }
}

