/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.crafting.compression;

import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import pl.asie.charset.lib.network.PacketTile;
import pl.asie.charset.module.crafting.compression.CharsetCraftingCompression;
import pl.asie.charset.module.crafting.compression.TileCompressionCrafter;

public class PacketCompactAnimation
extends PacketTile {
    private long craftingTickStart;
    private long craftingTickEnd;

    public PacketCompactAnimation(TileCompressionCrafter tile) {
        super((TileEntity)tile);
        this.craftingTickStart = tile.shape.craftingTickStart;
        this.craftingTickEnd = tile.shape.craftingTickEnd;
    }

    public PacketCompactAnimation() {
    }

    public void readData(INetHandler handler, PacketBuffer buf) {
        super.readData(handler, buf);
        this.craftingTickStart = buf.readLong();
        this.craftingTickEnd = this.craftingTickStart + (long)buf.func_150792_a();
    }

    public void apply(INetHandler handler) {
        super.apply(handler);
        if (this.tile instanceof TileCompressionCrafter) {
            TileCompressionCrafter crafter = (TileCompressionCrafter)this.tile;
            crafter.getShape(false);
            if (crafter.shape != null) {
                crafter.shape.craftingTickStart = this.craftingTickStart;
                crafter.shape.craftingTickEnd = this.craftingTickEnd;
                CharsetCraftingCompression.proxy.markShapeRender(crafter, crafter.shape);
            }
        }
    }

    public void writeData(PacketBuffer buf) {
        super.writeData(buf);
        buf.writeLong(this.craftingTickStart);
        buf.func_150787_b((int)(this.craftingTickEnd - this.craftingTickStart));
    }

    public boolean isAsynchronous() {
        return false;
    }
}

