/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.witty;

import com.zeitheron.hammercore.client.witty.DaylengthSplashes;
import com.zeitheron.hammercore.client.witty.IWittyComment;
import com.zeitheron.hammercore.client.witty.SplashModPool;
import com.zeitheron.hammercore.client.witty.WittyCommentChooseEvent;
import com.zeitheron.hammercore.lib.zlib.tuple.TwoTuple;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SplashTextHelper {
    public static IWittyComment splash;
    private static String lastSplashText;
    private static final List<TwoTuple<BooleanSupplier, String>> mods;

    public static void addModSplashesIfOneModInstalled(String ident, String ... modsOR) {
        mods.add(new TwoTuple<BooleanSupplier, String>(() -> {
            for (String mod : modsOR) {
                if (!Loader.isModLoaded((String)mod)) continue;
                return true;
            }
            return false;
        }, ident));
    }

    public static void addModSplashesIfAllModsInstalled(String ident, String ... modsAND) {
        mods.add(new TwoTuple<BooleanSupplier, String>(() -> {
            for (String mod : modsAND) {
                if (Loader.isModLoaded((String)mod)) continue;
                return false;
            }
            return true;
        }, ident));
    }

    public static String handle(String sp) {
        if (splash != null) {
            return splash.get();
        }
        return sp;
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent e) {
        if (e.getGui() instanceof GuiMainMenu) {
            String birthday = DaylengthSplashes.getDaylengthSplash();
            if (birthday != null) {
                splash = IWittyComment.ofStatic(birthday);
            } else {
                WittyCommentChooseEvent w = new WittyCommentChooseEvent();
                MinecraftForge.EVENT_BUS.post((Event)w);
                splash = w.getWittyComment();
            }
        }
    }

    @SubscribeEvent
    public void addSplashes(WittyCommentChooseEvent e) {
        ArrayList<String> sp = new ArrayList<String>();
        SplashTextHelper.addFormattedSubs("hc.splash", sp);
        for (TwoTuple<BooleanSupplier, String> tt : mods) {
            if (!tt.get1().getAsBoolean()) continue;
            SplashTextHelper.addFormattedSubs(tt.get2(), sp);
        }
        for (String modid : SplashModPool.modIds()) {
            if (Loader.isModLoaded((String)modid)) continue;
            sp.add(I18n.func_135052_a((String)"hc.splash.mod", (Object[])new Object[]{SplashModPool.getName(modid)}));
        }
        double log2 = Math.log(sp.size());
        log2 *= log2;
        if (!e.isCustomWittyComment() && (double)e.rand.nextFloat() * log2 < (double)(0.05f * (float)sp.size())) {
            e.setWittyComment(IWittyComment.ofStatic(this.replaceVars((String)sp.get(e.rand.nextInt(sp.size())))));
        }
    }

    private static void addFormattedSubs(String base, List<String> list) {
        String f;
        String raw;
        int t = 1;
        while (!(raw = base + '.' + t).equals(f = I18n.func_135052_a((String)raw, (Object[])new Object[0]))) {
            list.add(f);
            ++t;
        }
    }

    private String replaceVars(String str) {
        str = str.replaceAll("%player%", Minecraft.func_71410_x().func_110432_I().func_111285_a());
        return str;
    }

    static {
        mods = new ArrayList<TwoTuple<BooleanSupplier, String>>();
        SplashTextHelper.addModSplashesIfOneModInstalled("hc.splash.thaumcraft", "thaumcraft", "lostthaumaturgy");
        SplashTextHelper.addModSplashesIfOneModInstalled("hc.splash.draconicevolution", "draconicevolution");
        SplashTextHelper.addModSplashesIfOneModInstalled("hc.splash.ae2", "appliedenergistics2");
        SplashTextHelper.addModSplashesIfOneModInstalled("hc.splash.ic2", "ic2");
    }
}

