/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.world;

import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.api.CustomMonsterAttributes;
import com.zeitheron.hammercore.api.GameRules;
import com.zeitheron.hammercore.event.WorldEventsHC;
import com.zeitheron.hammercore.internal.chunk.ChunkPredicate;
import com.zeitheron.hammercore.lib.zlib.utils.IndexedMap;
import com.zeitheron.hammercore.world.gen.WorldRetroGen;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandGameRule;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class WorldGenHelper {
    public static final Map<Integer, List<Long>> CHUNKLOADERS = new IndexedMap<Integer, List<Long>>();
    private static final ArrayList<ChunkPredicate.LoadableChunk> LOADED_CHUNKS = new ArrayList();
    public static final Predicate<IBlockState> GRASS_OR_DIRT_CHECKER = state -> state != null && (state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150458_ak);
    public static final Predicate<IBlockState> NETHERRACK_CHECKER = state -> state != null && state.func_177230_c() == Blocks.field_150424_aL;
    public static final Predicate<IBlockState> END_STONE_CHECKER = state -> state != null && state.func_177230_c() == Blocks.field_150377_bs;
    public static final UUID FLIGHT_SPEED_UUID = UUID.fromString("08B6A944-A002-4715-BE52-E2DBAF61C4E9");
    public static final UUID MOVE_SPEED_UUID = UUID.fromString("08B6A944-A002-4715-BE52-E2DBAF61C4E9");

    public static void loadChunk(int world, BlockPos chunkloader) {
        List<Long> longs = CHUNKLOADERS.get(world);
        if (longs == null) {
            longs = new ArrayList<Long>();
            CHUNKLOADERS.put(world, longs);
        }
        if (!longs.contains(chunkloader.func_177986_g())) {
            longs.add(chunkloader.func_177986_g());
        }
        WorldGenHelper.reloadChunks();
    }

    public static ChunkPredicate.IChunkLoader chunkLoader() {
        return () -> LOADED_CHUNKS;
    }

    public static void unloadChunk(int world, BlockPos chunkloader) {
        List<Long> longs = CHUNKLOADERS.get(world);
        if (longs == null) {
            longs = new ArrayList<Long>();
            CHUNKLOADERS.put(world, longs);
        }
        if (longs.contains(chunkloader.func_177986_g())) {
            longs.remove(chunkloader.func_177986_g());
        }
        WorldGenHelper.reloadChunks();
    }

    public static void reloadChunks() {
        LOADED_CHUNKS.clear();
        for (Integer i : CHUNKLOADERS.keySet()) {
            for (Long l : CHUNKLOADERS.get(i)) {
                BlockPos pos = BlockPos.func_177969_a((long)l);
                LOADED_CHUNKS.add(new ChunkPredicate.LoadableChunk(i, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
            }
        }
    }

    public static void generateFlowerOnSameY(IBlockState flower, Random rand, World world, BlockPos basePos, int maxSpawnRad, int minFlowers, int maxFlowers, boolean oneChunkOnly, Predicate<IBlockState> soilChecker) {
        int count = minFlowers + rand.nextInt(maxFlowers - minFlowers);
        int fails = 0;
        while (count > 0) {
            boolean planted = false;
            int x = basePos.func_177958_n() + rand.nextInt(maxSpawnRad) - rand.nextInt(maxSpawnRad);
            int z = basePos.func_177952_p() + rand.nextInt(maxSpawnRad) - rand.nextInt(maxSpawnRad);
            BlockPos pos = new BlockPos(x, basePos.func_177956_o() - 1, z);
            if (oneChunkOnly && (pos.func_177958_n() >> 4 != basePos.func_177958_n() >> 4 || pos.func_177952_p() >> 4 != basePos.func_177952_p() >> 4)) {
                planted = false;
            } else if (soilChecker.test(world.func_180495_p(pos)) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                WorldGenHelper.setBlockState(world, pos.func_177984_a(), flower, null);
                planted = true;
            }
            if (!planted) {
                ++fails;
            }
            if (fails < 10 && !planted) continue;
            fails = 0;
            --count;
        }
    }

    public static void generateFlower(IBlockState flower, Random rand, World world, BlockPos basePos, int maxSpawnRad, int minFlowers, int maxFlowers, boolean oneChunkOnly, Predicate<IBlockState> soilChecker) {
        int count = minFlowers + rand.nextInt(maxFlowers - minFlowers);
        int fails = 0;
        while (count > 0) {
            boolean planted = false;
            int x = basePos.func_177958_n() + rand.nextInt(maxSpawnRad) - rand.nextInt(maxSpawnRad);
            int z = basePos.func_177952_p() + rand.nextInt(maxSpawnRad) - rand.nextInt(maxSpawnRad);
            BlockPos pos = new BlockPos(x, world.func_189649_b(x, z) - 1, z);
            if (oneChunkOnly && (pos.func_177958_n() >> 4 != basePos.func_177958_n() >> 4 || pos.func_177952_p() >> 4 != basePos.func_177952_p() >> 4)) {
                planted = false;
            } else if (soilChecker.test(world.func_180495_p(pos)) && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, pos.func_177984_a())) {
                WorldGenHelper.setBlockState(world, pos.func_177984_a(), flower, null);
                planted = true;
            }
            if (!planted) {
                ++fails;
            }
            if (fails < 10 && !planted) continue;
            fails = 0;
            --count;
        }
    }

    public static File getBlockSaveFile(World world) {
        return new File(world.func_72860_G().func_75765_b(), "world_data.hc");
    }

    public static void setBlockState(World world, BlockPos pos, IBlockState state, @Nullable TileEntity tile) {
        boolean logCascade = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        world.func_175656_a(pos, state);
        world.func_175690_a(pos, tile);
        ForgeModContainer.logCascadingWorldGeneration = logCascade;
    }

    public static void setBlockState(World world, BlockPos pos, IBlockState state) {
        WorldGenHelper.setBlockState(world, pos, state, null);
    }

    public static void setBlockState(World world, BlockPos pos, IBlockState state, int marker, @Nullable TileEntity tile) {
        boolean logCascade = ForgeModContainer.logCascadingWorldGeneration;
        ForgeModContainer.logCascadingWorldGeneration = false;
        world.func_180501_a(pos, state, marker);
        world.func_175690_a(pos, tile);
        ForgeModContainer.logCascadingWorldGeneration = logCascade;
    }

    public static void setBlockState(World world, BlockPos pos, IBlockState state, int marker) {
        WorldGenHelper.setBlockState(world, pos, state, marker, null);
    }

    @SubscribeEvent
    public static void chunkLoad(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        if (e.phase != TickEvent.Phase.END || e.side != Side.SERVER) {
            return;
        }
        if (player != null && !player.field_70170_p.field_72995_K && player.field_70173_aa % 10 == 0) {
            for (int x = -4; x < 4; ++x) {
                for (int z = -4; z < 4; ++z) {
                    BlockPos pos = player.func_180425_c().func_177982_a(x * 16, 0, z * 16);
                    if (!player.field_70170_p.func_175667_e(pos)) continue;
                    WorldRetroGen.generateChunk(player.field_70170_p.func_175726_f(pos));
                }
            }
        }
    }

    @SubscribeEvent
    public static void entityInit(EntityEvent.EntityConstructing e) {
        if (e.getEntity() instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)e.getEntity();
            p.func_110140_aT().func_111150_b(CustomMonsterAttributes.FLIGHT_SPEED);
            p.func_110140_aT().func_111150_b(CustomMonsterAttributes.WALK_SPEED);
        }
    }

    @SubscribeEvent
    public static void worldSaveEvt(WorldEvent.Save evt) {
        WorldGenHelper.threadSaveCustomData(evt.getWorld());
    }

    @SubscribeEvent
    public static void worldLoadEvt(WorldEvent.Load evt) {
        WorldGenHelper.threadLoadCustomData(evt.getWorld());
    }

    public static void threadSaveCustomData(World world) {
        new Thread(() -> {
            try {
                ObjectOutputStream o = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(WorldGenHelper.getBlockSaveFile(world))));
                o.writeObject(CHUNKLOADERS);
                IndexedMap<String, Serializable> pars = new IndexedMap<String, Serializable>();
                MinecraftForge.EVENT_BUS.post((Event)new WorldEventsHC.SaveData(world, pars));
                o.writeObject(pars);
                o.close();
            }
            catch (FileNotFoundException o) {
            }
            catch (Throwable err) {
                HammerCore.LOG.warn("Failed to save HammerCore custom data!");
                err.printStackTrace();
            }
        }).start();
    }

    public static void threadLoadCustomData(World world) {
        new Thread(() -> {
            try {
                IndexedMap pars;
                try {
                    ObjectInputStream i = new ObjectInputStream(new GZIPInputStream(new FileInputStream(WorldGenHelper.getBlockSaveFile(world))));
                    CHUNKLOADERS.putAll((Map)i.readObject());
                    pars = (IndexedMap)i.readObject();
                    i.close();
                }
                catch (Throwable err) {
                    if (!(err instanceof FileNotFoundException)) {
                        HammerCore.LOG.warn("Failed to load HammerCore custom data!");
                        err.printStackTrace();
                    } else {
                        HammerCore.LOG.warn("HammerCore custom data file not found! (this is not an issue!)");
                    }
                    pars = new IndexedMap();
                }
                MinecraftForge.EVENT_BUS.post((Event)new WorldEventsHC.LoadData(world, pars));
            }
            catch (Throwable err) {
                HammerCore.LOG.warn("Failed to load HammerCore custom data!");
                err.printStackTrace();
            }
        }).start();
    }

    @SubscribeEvent
    public static void livingFall(LivingFallEvent e) {
        e.setDamageMultiplier(e.getDamageMultiplier() * GameRules.getEntry("hc_falldamagemult").getFloat(e.getEntity().field_70170_p));
    }

    @SubscribeEvent
    public static void commandEvent(CommandEvent ce) {
        String rule;
        MinecraftServer mcs;
        String[] args;
        if (ce.getCommand() instanceof CommandGameRule && (args = ce.getParameters()).length == 1 && (mcs = ce.getSender().func_184102_h()) != null && GameRules.getEntry((String)rule).name.equals(rule = args[0])) {
            ce.getSender().func_145747_a((ITextComponent)new TextComponentTranslation(GameRules.getEntry((String)rule).i18nDesc, new Object[0]));
        }
    }

    @SubscribeEvent
    public static void worldUpdate(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            World w = e.world;
            if (!GameRules.getEntry("hc_rainfall").getBool(w)) {
                WorldInfo info = w.func_72912_H();
                info.func_176142_i(1000000);
                info.func_76080_g(0);
                info.func_76090_f(0);
                info.func_76084_b(false);
                info.func_76069_a(false);
            }
        }
    }
}

