/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft;

import com.xcompwiz.mystcraft.core.TaskQueueManager;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.world.profiling.ChunkProfiler;
import com.xcompwiz.mystcraft.world.profiling.GuiMystcraftProfiling;
import com.xcompwiz.mystcraft.world.profiling.InstabilityDataCalculator;
import com.xcompwiz.mystcraft.world.storage.ExternalSaveHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MystcraftFirstRun {
    private static final String SAVE_NAME = "mystcraft_profiling";
    private static boolean readyToPlay = false;
    private static InstabilityDataCalculator instabilitycalculator;
    private static MapStorage storage;
    private static GuiMystcraftProfiling guiscreen;

    @SideOnly(value=Side.CLIENT)
    public static void enable() {
        Minecraft mc = Minecraft.func_71410_x();
        if (guiscreen == null) {
            guiscreen = new GuiMystcraftProfiling(mc.field_71462_r);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static synchronized void start() {
        if (instabilitycalculator != null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ExternalSaveHandler savehandler = new ExternalSaveHandler(mc.field_71412_D, "mystcraft");
        storage = new MapStorage((ISaveHandler)savehandler);
        ChunkProfiler profiler = InstabilityDataCalculator.getChunkProfiler(storage);
        int remaining = InstabilityDataCalculator.getChunksRemaining(profiler);
        if (remaining == 0) {
            LoggerUtils.info("Client baseline profiling completed.", new Object[0]);
            InstabilityDataCalculator.updateInstabilityData(profiler);
            readyToPlay = true;
            return;
        }
        if (guiscreen == null) {
            guiscreen = new GuiMystcraftProfiling(mc.field_71462_r);
        }
        mc.func_147108_a((GuiScreen)guiscreen);
        WorldSettings worldsettings = new WorldSettings(0L, GameType.CREATIVE, true, false, WorldType.field_77137_b);
        worldsettings.func_77166_b();
        mc.func_71371_a(SAVE_NAME, SAVE_NAME, worldsettings);
        IntegratedServer mcserver = mc.func_71401_C();
        instabilitycalculator = new InstabilityDataCalculator((MinecraftServer)mcserver, storage);
        instabilitycalculator.setCallback(guiscreen);
        MinecraftForge.EVENT_BUS.register((Object)instabilitycalculator);
    }

    public static synchronized void stop() {
        if (storage == null || instabilitycalculator == null) {
            return;
        }
        storage.func_75744_a();
        instabilitycalculator.shutdown();
        MinecraftForge.EVENT_BUS.unregister((Object)instabilitycalculator);
        storage = null;
        instabilitycalculator = null;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            mc.field_71441_e.func_72882_A();
            mc.func_71403_a(null);
        }
    }

    public static boolean isStopped() {
        return storage == null && guiscreen != null;
    }

    public static boolean shouldRun() {
        return instabilitycalculator == null && Minecraft.func_71410_x().field_71441_e == null && !Minecraft.func_71410_x().func_71387_A();
    }

    @SideOnly(value=Side.CLIENT)
    public static synchronized void end() {
        Runnable deleteworld = new Runnable(){

            @Override
            public void run() {
                ISaveFormat isaveformat = Minecraft.func_71410_x().func_71359_d();
                isaveformat.func_75800_d();
                isaveformat.func_75802_e(MystcraftFirstRun.SAVE_NAME);
                readyToPlay = true;
            }
        };
        TaskQueueManager.runOnServerShutdown(deleteworld);
        MystcraftFirstRun.stop();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isReady() {
        return readyToPlay;
    }

    public static void showProfilingGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)guiscreen);
    }

    public static void onSaveEvent(WorldEvent.Save event) {
        if (storage != null) {
            storage.func_75744_a();
        }
    }

    public static boolean isEnabled() {
        return guiscreen != null;
    }
}

